<?php include('resources/header.php'); ?>
<style>
    .thankyou-wrapper {
        min-height: 80vh;
        display: flex;
        align-items: center;
        justify-content: center;
        text-align: center;
        padding: 40px 20px;
        background: #fdfdfd;
        box-shadow: 0 -4px 12px rgba(0, 0, 0, 0.06);
    }

    .thankyou-box {
        background: #fff;
        padding: 40px 50px;
        border-radius: 16px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        max-width: 600px;
        width: 100%;
        animation: fadeInUp 0.5s ease-in-out;
        position: relative;
    }

    .thankyou-box h1 {
        font-size: 36px;
        font-weight: 700;
        background: linear-gradient(135deg, #ff4838, #ff7c5c);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 20px;
    }

    .thankyou-box p {
        font-size: 18px;
        color: #555;
        margin-bottom: 30px;
    }

    .btn-skip-modern {
        background: linear-gradient(135deg, #ff4838, #ff7c5c);
        color: #fff;
        padding: 12px 28px;
        font-size: 16px;
        font-weight: 600;
        border: none;
        border-radius: 8px;
        box-shadow: 0 4px 10px rgba(255, 72, 56, 0.3);
        transition: all 0.3s ease-in-out;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
    }

    .btn-skip-modern:hover {
        background: linear-gradient(135deg, #ff7c5c, #ff4838);
        transform: translateY(-2px);
        box-shadow: 0 6px 14px rgba(255, 72, 56, 0.4);
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(40px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .invoice-box {
        padding: 20px;
        border-radius: 12px;
        background-color: #fff;
    }

    .invoice-box h5 {
        margin-bottom: 10px;
        font-weight: 600;
        color: #333;
    }

    .btn-outline-primary {
        color: #ec5e49;
        border-color: #ec5e49;
    }

    .btn-outline-primary:hover {
        color: #fff;
        background-color: #ec5e49;
        border-color: #eb5e49;
    }

    .qr-image-wrapper {
        margin-top: 15px;
    }

    .qr-image-wrapper img {
        max-width: 100%;
        height: auto;
        border: 1px solid #eee;
        border-radius: 8px;
        padding: 10px;
        background-color: #fafafa;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    /* Timer styling */
    .timer-box {
    font-size: 16px;
    font-weight: bold;
    color: #ff4838;
    background: #fff8f5;
    border: 1px solid #ffd3cc;
    padding: 6px 12px;
    border-radius: 6px;
    display: inline-block;
    margin-top: 10px;
}










</style>

<?php
$car_booking_amount = mysqli_query($conn, "SELECT * FROM car_bookings ORDER BY id DESC LIMIT 1");
$paid_amount = mysqli_fetch_assoc($car_booking_amount);
$paid = $paid_amount['paid_amount'];
$total = $paid_amount['total_amount'];
$car_booking_id=$paid_amount['id'];
$fetch_invoiceNo=mysqli_query($conn,"SELECT invoice_number  FROM `invoices` WHERE booking_id=$car_booking_id");
$invoice=mysqli_fetch_assoc($fetch_invoiceNo);
?>

<div class="thankyou-wrapper">
    <div class="thankyou-box">
          
        

        <h1>Scan for Payment</h1>
        <div class="invoice-box">
            <h5>
                Amount:
                <strong>₹<?php echo ($paid == 0) ? $total : $paid; ?></strong>
            </h5>
            <div class="qr-image-wrapper">
                <?php
                    $invNo=$invoice['invoice_number'];
                    $amount = ($paid == 0) ? $total : $paid;
                    $amount = number_format($amount, 2, '.', '');
                    $upi_url = "upi://pay?pa=8420673485-3@ybl&pn=MOUNTAIN%20INN&tn=Payment to Mountain INN&mc=0000&mode=02&purpose=00&tr={$invNo}&am={$amount}&cu=INR";
                    $qr_encoded_url = urlencode($upi_url);
                ?>
                    <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo $qr_encoded_url; ?>"
                         alt="Scan to Pay via UPI"
                         id="qrImage"
                         width="150" height="150">
                         
                         
            </div>    
                <!-- Timer below QR -->
                <div class="timer-box" style="position: static; margin-top: 10px;">
                    Time Left: <span id="countdown">02:00</span>
                </div>
            
        </div>
         <div class="payment-alert-overlay" id="paymentAlert">
            <div class="payment-alert-box">
                <!--<h4>Notice</h4>-->
                <p>If the page is not redirected automatically <strong>click the proceed button below</strong>.</p>
                <!--<button onclick="document.getElementById('paymentAlert').style.display='none'">OK</button>-->
            </div>
        </div>
        <a href="thank-you.php" class="btn-skip-modern mt-4">
            Click to proceed <i class="fa-solid fa-arrow-right ms-2"></i>
        </a>
    </div>
</div>

<?php include('resources/footer.php'); ?>

<!-- Countdown Script -->
<script>
    let time = 120; // 2 minutes = 120 seconds
    const countdownEl = document.getElementById('countdown');

    const timerInterval = setInterval(function () {
        const minutes = Math.floor(time / 60);
        const seconds = time % 60;

        countdownEl.textContent = `${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;

        if (time <= 0) {
            clearInterval(timerInterval);
            window.location.href = "thank-you.php"; // auto redirect
        }

        time--;
    }, 1000);
</script>
