<?php
include('resources/header.php');
if (!isset($_GET['id']) || empty($_GET['id']) || !isset($_GET['type']) || empty($_GET['type'])) {

    header("Location: index.php");
    exit();
}
$id = intval($_GET['id']); 
$type = trim($_GET['type']);
$resort_fetch_query=mysqli_query($conn,"SELECT * FROM Hotel_Add WHERE property_Type='$type' AND hotel_id = $id");
$property = mysqli_fetch_assoc($resort_fetch_query);


if (isset($_POST['book_now_property'])) {

    $property_id = $_POST['property_id'];
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $adults = $_POST['adults'];
    $children = $_POST['children'];
    $room_id = $_POST['room_id'];
    $number_of_rooms = $_POST['number_of_rooms'];
    $fromDate = $_POST['fromDate'];
    $toDate = $_POST['toDate'];
    $message = $_POST['message'];
    $total = $_POST['total'];

    // Sanitize inputs to prevent SQL injection
    $property_id = intval($property_id);
    $name = $conn->real_escape_string($name);
    $email = $conn->real_escape_string($email);
    $phone = $conn->real_escape_string($phone);
    $adults = intval($adults);
    $children = intval($children);
    $room_id = intval($room_id);
    $number_of_rooms = intval($number_of_rooms);
    $fromDate = $conn->real_escape_string($fromDate);
    $toDate = $conn->real_escape_string($toDate);
    $message = $conn->real_escape_string($message);
    

    // Insert booking query
    $insertBookingQuery = "
        INSERT INTO property_bookings 
        (property_id, name, email, phone, adults, children, room_id, number_of_rooms, check_in, check_out, message, total_amount) 
        VALUES 
        ($property_id, '$name', '$email', '$phone', $adults, $children, $room_id, $number_of_rooms, '$fromDate', '$toDate', '$message', $total)
    ";
    // echo $insertBookingQuery;
    if ($conn->query($insertBookingQuery)) {
        $lastInsertedBookingId = $conn->insert_id;
        $invoiceNumber = 'INV' . date('YmdHis');
        $bookingType = 'property_bookings';
        $bookingId = $lastInsertedBookingId;

        // Insert invoice query
        $insertInvoiceQuery = "
            INSERT INTO invoices (invoice_number, booking_type, booking_id) 
            VALUES ('$invoiceNumber', '$bookingType', $bookingId)
        ";

        if ($conn->query($insertInvoiceQuery)) {
            echo "<script>
                    alert('Booking successful!');
                    window.location.href = 'index.php';
                </script>";
            // echo "Booking and invoice creation successful!";
            // header("Location: all-booking.php");
            exit(); // Prevent further execution after the redirect
        } else {
            echo "Error inserting invoice: " . $conn->error;
        }
    } else {
        echo "Error inserting property booking: " . $conn->error;
    }

    $conn->close();
}
?>
<style>
    .custom-input-group button[type=button] {
    font-weight: 700;
    font-size: 16px;
    color: #ffffff;
    background: #ff4838;
    border-radius: 100px;
    border: none;
    padding: 14px 38px;
    transition: all 0.2s;
}
.custom-input-group label {
    font-size: 12px;
}

</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<!-- ===============  breadcrumb area start =============== -->
    <div class="breadcrumb breadcrumb-style-one">
        <div class="container">
            <div class="col-lg-12 text-center">
                <h2 class="breadcrumb-title"><?php echo $type . 's'; ?></h2>
                <ul class="d-flex justify-content-center breadcrumb-items">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active"><?php echo htmlspecialchars($property['name']); ?></li>
                </ul>
            </div>
        </div>
    </div>
    <!-- ===============  breadcrumb area end =============== -->

    <div class="package-details-wrapper pt-76">
        <div class="container">
           <div class="row ">
               <div class="col-lg-6">
                <div class="tour-package-details">
                    <div class="pd-header">
                        
    
                        <div class="pd-thumb pt-0">
                            <img src="admin/dashboard/<?php echo $property['cover_img']; ?>" alt="" style="max-width:700px;max-height:500px; min-width:300px;min-height:200px;">
                        </div>

                        <div class="header-bottom">
                            <div class="pd-lavel d-flex justify-content-between align-items-center flex-wrap gap-2">
                                <h5 class="location"><i class="bi bi-geo-alt"></i> <?php echo $property['city']; ?>,<?php echo $property['state']; ?>,<?php echo $property['country']; ?></h5>
                                <!--<ul class="d-flex align-items-center rating">-->
                                <!--    <li><i class="bi bi-star-fill"></i></li>-->
                                <!--    <li><i class="bi bi-star-fill"></i></li>-->
                                <!--    <li><i class="bi bi-star-fill"></i></li>-->
                                <!--    <li><i class="bi bi-star-fill"></i></li>-->
                                <!--    <li><i class="bi bi-star-fill"></i></li>-->
                                <!--</ul>-->
                            </div>
                            <h2 class="pd-title"><?php echo htmlspecialchars($property['name']); ?></h2>
                        </div>
                    </div>


                    <div class="package-details-tabs">
                        <ul class="nav nav-pills tab-switchers gap-xxl-4 gap-3" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                              <button class="nav-link active" id="pills-package1" data-bs-toggle="pill" data-bs-target="#pill-body1" type="button" role="tab" aria-controls="pill-body1" aria-selected="true"><i class="bi bi-info-lg"></i> Information</button>
                            </li>
                            <li class="nav-item" role="presentation">
                              <button class="nav-link" id="pills-package2" data-bs-toggle="pill" data-bs-target="#pill-body2" type="button" role="tab" aria-controls="pill-body2" aria-selected="false"> <i class="bi bi-file-earmark-spreadsheet"></i> Rooms</button>
                            </li>
                            <li class="nav-item" role="presentation">
                              <button class="nav-link" id="pills-package4" data-bs-toggle="pill" data-bs-target="#pill-body4" type="button" role="tab" aria-controls="pill-body4" aria-selected="false"><i class="bi bi-geo-alt"></i> Location</button>
                            </li>
                          </ul>

                          <div class="tab-content" id="pills-tabContent">

                             <!-- package info tab -->
                            <div class="tab-pane fade show active package-info-tab mt-3" id="pill-body1" role="tabpanel" aria-labelledby="pills-package1">
                                <h3 class="d-subtitle">Property Details</h3>
                                <p><?php echo $property['short_Description']; ?></p>
                                <p><?php echo $property['full_Description']; ?></p>

                                <table class="table package-info-table mb-4 mb-sm-4">
                                    <tbody>
                                        <tr>
                                            <th>Property Type</th>
                                            <td><?php echo $property['property_Type']; ?> Room</td> <!-- Change to Homestay / Resort Room as needed -->
                                        </tr>
                                        <tr>
                                            <th>Location</th>
                                            <td><?php echo $property['city']; ?>, <?php echo $property['state']; ?>, <?php echo $property['country']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Check-in</th>
                                            <td><?php echo $property['checkIn']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Check-out</th>
                                            <td><?php echo $property['checkOut']; ?></td>
                                        </tr>
                                        <?php
                                        $features = [
                                            'wifi' => 'Wi-Fi',
                                            'parking' => 'Parking',
                                            'breakfast' => 'Breakfast',
                                            'pool' => 'Swimming Pool',
                                            'garden' => 'Garden',
                                            'view' => 'Scenic View',
                                            'reception' => '24/7 Reception',
                                            'housekeeping' => 'Housekeeping',
                                            'bonfire' => 'Bonfire',
                                            'activities' => 'Activities',
                                            'games' => 'Indoor Games',
                                            'hall' => 'Conference Hall',
                                            'dinning' => 'Dining Area',
                                            'kitchen_access' => 'Kitchen Access',
                                            'pet' => 'Pet Friendly',
                                            'family' => 'Family Friendly',
                                            'couple' => 'Couple Friendly',
                                            'wheelchair' => 'Wheelchair Accessible',
                                            'cancellation' => 'Free Cancellation',
                                            'smoking' => 'Smoking Allowed',
                                            'pet_policy' => 'Pet Policy',
                                        ];
                                        
                                        $included = [];
                                        $excluded = [];
                                        
                                        foreach ($features as $key => $label) {
                                            if (!empty($property[$key])) {
                                                $included[] = $label;
                                            } else {
                                                $excluded[] = $label;
                                            }
                                        }
                                        ?>
                                        
                                        <tr>
                                            <th>Included</th>
                                            <td>
                                                <ul class="included-list">
                                                    <?php foreach ($included as $item): ?>
                                                        <li><i class="bi bi-check2"></i> <?php echo $item; ?></li>
                                                    <?php endforeach; ?>
                                                </ul>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>


                
                                
                            </div>

                             <!-- package plans tab -->
                            <div class="tab-pane fade package-plan-tab tab-body mt-3" id="pill-body2" role="tabpanel" aria-labelledby="pills-package2">
                                <h3 class="d-subtitle">Room Details</h3>
                                <p>This spacious and elegantly designed Deluxe King Room offers the perfect blend of comfort and luxury. Featuring a plush king-size bed, modern interiors, a dedicated workspace, and a large window with city views, it's ideal for both business and leisure travelers. Guests can enjoy amenities such as high-speed Wi-Fi, smart TV, in-room dining, and a well-appointed en-suite bathroom with premium toiletries. Whether you're staying for a night or a week, this room ensures a relaxing and enjoyable experience.</p>



                                <div class="accordion plans-accordion mb-4" id="roomAccordion">
                                    <?php
                                    // SQL query to fetch all room details for the given hotel
                                    $sql = mysqli_query($conn, "SELECT * FROM room_details WHERE hotel_id = '$id'");
                                    $roomIndex = 1;
                                    
                                    // Loop through each room
                                    while($sql_row = mysqli_fetch_assoc($sql)) {
                                        $roomId = "roomCollapse" . $roomIndex;
                                        $headingId = "roomHeading" . $roomIndex;
                                    ?>
                                    <div class="accordion-item plans-accordion-single">
                                        <div class="accordion-header" id="<?php echo $headingId; ?>">
                                            <div class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#<?php echo $roomId; ?>" aria-expanded="false" aria-controls="<?php echo $roomId; ?>" role="navigation">
                                                <div class="paln-index-circle">
                                                    <h4><?php echo str_pad($roomIndex, 2, '0', STR_PAD_LEFT); ?></h4>
                                                </div>
                                                <div class="plan-title">
                                                    <h5><?php echo $sql_row['room_name']; ?></h5>
                                                    <h6>Starting ₹<?php echo $sql_row['price_per_night']; ?>/night</h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="<?php echo $roomId; ?>" class="accordion-collapse collapse" aria-labelledby="<?php echo $headingId; ?>" data-bs-parent="#roomAccordion">
                                            <div class="accordion-body plan-info">
                                                
                                                <div class="row col-sm-12">
                                                    <?php
                                   $imagePath = 'admin/dashboard/' . $sql_row['room_img'];

                                       if (!empty($sql_row['room_img']) && file_exists($imagePath)) {
                                     echo '<img src="' . $imagePath . '" style="max-width:500px; max-height:300px; min-width:100px; min-height:75px;">';
                                           }
                                           ?>
                                                    <!--<img src="admin/dashboard/<?php echo $sql_row['room_img']; ?>" style="max-width:500px;max-height:300px;min-width:100px;min-height:75px;">-->
                                                </div>
                                                <p><strong>Description:</strong> <?php echo $sql_row['room_description']; ?></p>
                                                <p><strong>Room Size:</strong> <?php echo $sql_row['room_size']; ?> sq.ft.</p>
                                                <p><strong>Occupancy:</strong> <?php echo $sql_row['occupancy']; ?> people</p>
                                                <p><strong>Extra Person Charges:</strong> ₹<?php echo $sql_row['extra_charges']; ?></p>
                                                <p><strong>Discount:</strong> <?php echo $sql_row['discount']; ?>%</p>
                                                <p><strong>Cleaning Fee:</strong> ₹<?php echo $sql_row['cleaning_fee']; ?></p>
                                                
                                                <ul>
                                                    <?php if($sql_row['attached_bathroom']) echo '<li><i class="bi bi-check-lg"></i> Attached Bathroom</li>'; ?>
                                                    <?php if($sql_row['ac']) echo '<li><i class="bi bi-check-lg"></i> Air Conditioning</li>'; ?>
                                                    <?php if($sql_row['heater']) echo '<li><i class="bi bi-check-lg"></i> Heater</li>'; ?>
                                                    <?php if($sql_row['tv']) echo '<li><i class="bi bi-check-lg"></i> Smart TV</li>'; ?>
                                                    <?php if($sql_row['geyser']) echo '<li><i class="bi bi-check-lg"></i> Geyser</li>'; ?>
                                                    <?php if($sql_row['kitchen']) echo '<li><i class="bi bi-check-lg"></i> Kitchen</li>'; ?>
                                                    <?php if($sql_row['towels']) echo '<li><i class="bi bi-check-lg"></i> Towels</li>'; ?>
                                                    <?php if($sql_row['garden_view']) echo '<li><i class="bi bi-check-lg"></i> Garden View</li>'; ?>
                                                    <?php if($sql_row['wardrobe']) echo '<li><i class="bi bi-check-lg"></i> Wardrobe</li>'; ?>
                                                    <?php if($sql_row['deskChair']) echo '<li><i class="bi bi-check-lg"></i> Desk & Chair</li>'; ?>
                                                    <?php if($sql_row['mini_Fridge']) echo '<li><i class="bi bi-check-lg"></i> Mini Fridge</li>'; ?>
                                                    <?php if($sql_row['room_service']) echo '<li><i class="bi bi-check-lg"></i> Room Service</li>'; ?>
                                                </ul>
                                
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    $roomIndex++;
                                    }
                                    mysqli_data_seek($sql, 0); // Reset result pointer to the beginning

                                    ?>
                                    
                                </div>




                            </div>

                            <div class="tab-pane fade package-location-tab mt-3" id="pill-body4" role="tabpanel" aria-labelledby="pills-package4">

                              <!-- Property Address Card -->
                              <div class="card shadow p-4 rounded-4 mb-4">
                                <div class="card-body">
                                  <h4 class="card-title mb-3">Property Location Details</h4>
                            
                                  <div class="row mb-3">
                                    <div class="col-md-6">
                                      <p><strong>Street:</strong> <?php echo $property['street']; ?></p>
                                      <p><strong>City:</strong> <?php echo $property['city']; ?></p>
                                    </div>
                                    <div class="col-md-6">
                                      <p><strong>State:</strong> <?php echo $property['district']; ?></p>
                                      <p><strong>Pin Code:</strong> <?php echo $property['pin']; ?></p>
                                    </div>
                                    <div class="col-md-6">
                                      <p><strong>Country:</strong> <?php echo $property['country']; ?></p>
                                    </div>
                                  </div>
                            
                                </div>
                              </div>
                            </div>

                          </div>
                    </div>
                </div>
               </div>

               <div class="col-lg-6">
                   <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-20">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Book This Property</h4>
                            <!--<h3 class="widget-lavel">$75 <span>Per Person</span></h3>-->

                        </div>
                        
                        <div class="widget-body mb-4 mb-sm-4">
                            <form action="car_suggestion.php" method="post">
                                <input type="hidden" name="property_id" value="<?php echo $property['hotel_id']; ?>">
                                <div class="booking-form-wrapper">
                                    <div class="custom-input-group">
                                        <input type="text" placeholder="Your Full Name" id="name" name="name" required>
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="email" placeholder="Your Email" id="email" name="email" required>
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="tel" placeholder="Phone" id="phone" name="phone" maxlength="10"
                                        pattern="\d{10}"
                                        title="Enter exactly 10 digits" required>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="custom-input-group">
                                                <i class="bi bi-chevron-down"></i>
                                                <select id="truist-adult" name="adults" required>
                                                    <option value="" disabled selected>Adult</option>
                                                    <?php for ($i = 1; $i <= 20; $i++): ?>
                                                        <option value="<?= $i ?>"><?= $i ?></option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="custom-input-group">
                                        <i class="bi bi-chevron-down"></i>
                                        <select id="room-selection" name="room_id" required>
                                            <option value="" disabled selected>Select a Room</option>
                                            <?php
                                            while($row = mysqli_fetch_assoc($sql)) {
                                                $roomName = htmlspecialchars($row['room_name']);
                                                $price = $row['price_per_night'];
                                                $occupancy = $row['occupancy'];
                                                $discount = $row['discount'];
                                                
                                                $displayText = $roomName . ' – ₹' . number_format($price) . '/night';
                                                if ($discount > 0) {
                                                    $displayText .= ' ('. $discount .'% off)';
                                                }
        
                                                echo '<option 
                                                    value="' . $row['roomId'] . '" 
                                                    data-price="' . $price . '" 
                                                    data-occupancy="' . $occupancy . '" 
                                                    data-discount="' . $discount . '">'
                                                   . $displayText . '</option>';
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="custom-input-group">
                                        <i class="bi bi-chevron-down"></i>
                                        <select id="no-of-rooms" name="number_of_rooms" required>
                                            <option value="" disabled selected>No. of Rooms</option>
                                        </select>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="custom-input-group">
                                                <label for="fromDate" class="form-label m-0">Check-in Date</label>
                                                <input placeholder="Check-in" type="date" name="fromDate" id="fromDate" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="custom-input-group ">
                                                <label for="toDate" class="form-label m-0">Check-out Date</label>
                                                <input placeholder="Check-out" type="date" name="toDate" id="toDate" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="custom-input-group">
                                        <textarea cols="20" rows="7" placeholder="Your message" name="message"></textarea>
                                    </div>
                            
                                    <!-- Total price field -->
                                    <div class="custom-input-group">
                                        <input type="text" id="total" name="" placeholder="Total Amount" readonly>
                                    </div>
                                    <input type="hidden" id="total-hidden" name="total" value="">
                                    <div class="custom-input-group">
                                        <div class="submite-btn">
                                            <!--<button type="button" onclick="window.location.href='car_suggestion.php';">Next</button>-->
                                            <!--<button type="submit" name="book_now_property">Book Now</button>-->
                                            <button type="submit">Next</button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </aside>
                   </div>
               </div>
           </div>
        </div>
    </div>
   
<?php
include('./resources/footer.php');
?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const adultSelect = document.getElementById('truist-adult');
    const roomSelect = document.getElementById('room-selection');
    const noOfRoomsSelect = document.getElementById('no-of-rooms');

    function updateRoomOptions() {
        const adults = parseInt(adultSelect.value);
        const selectedOption = roomSelect.options[roomSelect.selectedIndex];

        if (!adults || !selectedOption) return;

        const occupancy = parseInt(selectedOption.getAttribute('data-occupancy'));

        if (!occupancy || occupancy <= 0) return;

        const minRooms = Math.ceil(adults / occupancy);
        const maxRooms = 10; // Max cap for UI

        // Clear old options
        noOfRoomsSelect.innerHTML = '<option disabled selected>No. of Rooms</option>';

        // Populate new options from minRooms to maxRooms
        for (let i = minRooms; i <= maxRooms; i++) {
            const option = document.createElement('option');
            option.value = i;
            option.textContent = i;
            noOfRoomsSelect.appendChild(option);
        }
    }

    // Trigger update when either field changes
    adultSelect.addEventListener('change', updateRoomOptions);
    roomSelect.addEventListener('change', updateRoomOptions);
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const today = new Date().toISOString().split('T')[0];
    const fromDateInput = document.getElementById('fromDate');
    const toDateInput = document.getElementById('toDate');

    // Disable previous dates
    fromDateInput.setAttribute('min', today);
    toDateInput.setAttribute('min', today);

    // Optional: Auto-adjust checkout date based on check-in
    fromDateInput.addEventListener('change', function () {
        const selectedFrom = fromDateInput.value;
        toDateInput.setAttribute('min', selectedFrom);
    });
});
</script>

<script>
function calculateTotal() {
    const roomOption = $('#room-selection option:selected');
    const roomCount = parseInt($('#no-of-rooms').val()) || 0;
    const fromDateVal = $('#fromDate').val();
    const toDateVal = $('#toDate').val();
    const from = new Date(fromDateVal);
    const to = new Date(toDateVal);

    console.log("Selected Room ID:", roomOption.val());
    console.log("Number of Rooms:", roomCount);
    console.log("From Date:", fromDateVal);
    console.log("To Date:", toDateVal);

    if (!roomOption.val() || roomCount === 0 || isNaN(from.getTime()) || isNaN(to.getTime())) {
        console.log("Missing or invalid inputs");
        $('#total').val('');
        $('#total-hidden').val('');
        return;
    }

    const price = parseFloat(roomOption.data('price')) || 0;
    const discount = parseFloat(roomOption.data('discount')) || 0;
    const days = Math.ceil((to - from) / (1000 * 60 * 60 * 24));

    console.log("Price per night:", price);
    console.log("Discount %:", discount);
    console.log("Number of Nights:", days);

    if (days <= 0) {
        console.log("Invalid date range");
        $('#total').val('Invalid Dates');
        $('#total-hidden').val('');
        return;
    }

    let total = price * roomCount * days;
    if (discount > 0) {
        const discountAmount = total * (discount / 100);
        total -= discountAmount;
        console.log("Discount Amount:", discountAmount);
    }

    console.log("Total Price:", total);
    $('#total').val('₹' + total.toFixed(2));
    $('#total-hidden').val(total.toFixed(2));
}

$(document).ready(function () {
    $('#room-selection, #no-of-rooms, #fromDate, #toDate').on('change', calculateTotal);
});
</script>


