<?php
include('./admin/dashboard/config/dbcon.php');

// if (isset($_POST['hotel_id'])) {
//     $hotel_id = intval($_POST['hotel_id']);
//     $sql = mysqli_query($conn, "SELECT * FROM room_details WHERE hotel_id = $hotel_id");

//     while ($row = mysqli_fetch_assoc($sql)) {
//         $roomName = htmlspecialchars($row['room_name']);
//         $price = $row['price_per_night'];
//         $occupancy = $row['occupancy'];
//         $discount = $row['discount'];

//         $displayText = $roomName . ' – ₹' . number_format($price) . '/night';
//         if ($discount > 0) {
//             $displayText .= " ({$discount}% off)";
//         }

//         echo '<option 
//             value="' . $row['roomId'] . '" 
//             data-price="' . $price . '" 
//             data-occupancy="' . $occupancy . '" 
//             data-discount="' . $discount . '">' 
//             . $displayText . '</option>';
//     }
// }
?>
<?php
if (isset($_POST['hotel_id'])) {
    $hotel_id = $_POST['hotel_id'];
    
    // Database connection (assuming $conn is your DB connection)
    $query = "SELECT * FROM room_details WHERE hotel_id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $hotel_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $rooms = [];
    while ($row = $result->fetch_assoc()) {
        $rooms[] = [
            'roomId' => $row['roomId'],
            'room_name' => $row['room_name'],
            'price_per_night' => $row['price_per_night'],
            'discount' => $row['discount'],
            'occupancy' => $row['occupancy']
        ];
    }

    echo json_encode($rooms);
}
?>
