<?php
include('resources/header.php');
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $_SESSION['property_booking'] = $_POST;
    $Hid= $_POST['property_id'];
    // echo '<pre>';
    // print_r($_SESSION['property_booking']);
    // echo '</pre>';
    $property_id = $_POST['property_id'];
    $name = $_POST['name'];
    $fullName = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $adults = $_POST['adults'];
    $room_id = $_POST['room_id'];
    $number_of_rooms = $_POST['number_of_rooms'];
    $fromDate = $_POST['fromDate'];
    $toDate = $_POST['toDate'];
    $message = $_POST['message'];
    $total = $_POST['total'];
    
    $start = new DateTime($fromDate);
    $end = new DateTime($toDate);
    $Hdiff = $start->diff($end)->days;
    
    $number_of_days = $Hdiff > 0 ? $Hdiff : 1; 
    
$room_fetch_query=mysqli_query($conn,"SELECT * FROM room_details WHERE roomId = $room_id");
$room = mysqli_fetch_assoc($room_fetch_query);
  
}else {
    header("Location: hotels.php");
    exit();
}

$resort_fetch_query=mysqli_query($conn,"SELECT * FROM Hotel_Add WHERE hotel_id = $Hid");
$property = mysqli_fetch_assoc($resort_fetch_query);
$HotelspotA=htmlspecialchars($property['choose']);
$HotelspotB=htmlspecialchars($property['choose']);


$whereClauses = ["add_car_details.status = '1'"];


$whereClauses[] = "(add_car_details.spotA = '$HotelspotA' OR add_car_details.spotB = '$HotelspotB')";

$whereSQL = implode(" AND ", $whereClauses);

$spot_fetch = mysqli_query($conn, "
    SELECT add_car_details.*, 
           spotA_table.spot AS spotA_name, 
           spotB_table.spot AS spotB_name 
    FROM add_car_details 
    LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId 
    LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId 
    WHERE $whereSQL
");
// error_log('hi');
?>
<style>
    .form-control-modern {
  border-radius: 10px;
  border: 1px solid #ced4da;
  padding: 10px 14px;
  font-size: 15px;
  transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #eb5744 !important;
    box-shadow: 0 0 0 0.2rem rgb(253 13 113 / 15%) !important;
}
.package-card-alpha .package-card-body .p-card-bottom .book-btn button {
    display: inline-block;
    font-weight: 600;
    font-size: 15px;
    text-transform: uppercase;
    color: #ff4838;
    /*background: #ffffff;*/
    border: 1px solid #ff4838;
    box-sizing: border-box;
    border-radius: 5px;
    padding: 8px 16px;
    transition: all 0.3s;
}

.btn-skip-modern {
    background: linear-gradient(135deg, #ff4838, #ff7c5c);
    color: #fff;
    padding: 12px 28px;
    font-size: 16px;
    font-weight: 600;
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgba(255, 72, 56, 0.3);
    transition: all 0.3s ease-in-out;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-skip-modern:hover {
    background: linear-gradient(135deg, #ff7c5c, #ff4838);
    transform: translateY(-2px);
    box-shadow: 0 6px 14px rgba(255, 72, 56, 0.4);
}
   .booking-action-btn {
        transition: all 0.3s ease;
        font-weight: 600;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        padding: 12px 20px;
    }

    .booking-action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    }

    .booking-action-btn:active {
        transform: scale(0.98);
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
    }

    .btn-book-car-only {
        background: linear-gradient(135deg, #ff4838, #ff7c5c);
        color: #fff;
        border: none;
    }

    .btn-book-car-only:hover {
        background: linear-gradient(135deg, #ff7c5c, #ff4838);
        color: #fff;
        /*border: 2px solid #ff7c5c;*/
    }

    .btn-book-car-property {
        background: linear-gradient(135deg, #007bff, #6610f2);
        color: white;
        border: none;
    }

    .btn-book-car-property:hover {
        background: linear-gradient(135deg, #6610f2, #007bff);
    }

    .fade-in-up {
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>
<!-- ===============  breadcrumb area start =============== -->
<!-- ===============  breadcrumb area start =============== -->
<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Car Suggestions</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item"><a href="property_details.php?id=<?php echo $property['hotel_id']; ?>">
                    <?php echo htmlspecialchars($property['name']); ?>
                </a></li>
                <li class="breadcrumb-item active">Car Suggestions</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->

<div class="package-details-wrapper pt-76">
    <div class="container">
        <div class="row">
            <!-- LEFT COLUMN -->
            <div class="col-lg-12 mb-4">
                <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-20">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Booking Details</h4>
                             <h3 class="widget-lavel"><span>Total Amount:</span> ₹<?php echo $total?></h3>
                        </div>

                        <div class="widget-body mb-4 mb-sm-4">
                            <form action="checkout.php" method="post">
                                <div class="booking-form-wrapper row">
                                    <?php
                                    if (!empty($_POST['property_id'])) {
                                    ?>
                                    <!-- Hotel Info -->
                                    <div class="mb-4 col-6 p-3 rounded bg-light border">
                                        <h5 class="text-primary mb-2"><?php echo $property['name']; ?></h5>
                                        <p class="mb-1"><strong> Location:</strong> <?php echo $property['city']; ?>, <?php echo $property['state']; ?>, <?php echo $property['country']; ?></p>
                                        <p class="mb-1"><strong> Check-in:</strong> <span class="text-dark"><?php echo $fromDate; ?>, <?php echo $property['checkIn']; ?></span></p>
                                        <p class="mb-0"><strong> Check-out:</strong> <span class="text-dark"><?php echo $toDate; ?>, <?php echo $property['checkOut']; ?></span></p>
                                    </div>
                                    
                                    <!-- Room Info -->
                                    <div class="mb-4 col-6 p-3 rounded bg-light border">
                                        <h6 class="text-dark mb-2">Room Info</h6>
                                        <p class="mb-1"><strong>Type:</strong> <?php echo $room['room_name']; ?></p>
                                        <p class="mb-1"><strong>Price/Night:</strong> <span class="badge bg-success text-white">₹<?php echo $room['price_per_night']; ?></span></p>
                                        <p class="mb-0"><strong>No. of Rooms:</strong> <?php echo $number_of_rooms; ?> rooms for <?php echo $number_of_days; ?> days</p>
                                        <p class="mb-1"><strong>Total Price:</strong> <span class="badge bg-success text-white">₹<?php echo $total; ?></span></p>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <!-- Total -->
                                    <hr class="my-3">
                                    <div class="d-flex justify-content-between gap-3 mt-4 fade-in-up">
                                        <!--<form  class="text-center mb-3">-->
                                            <?php if (isset($_SESSION['property_booking'])): ?>
                                                <input type="hidden" name="hotel_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['property_booking'])); ?>">
                                            <?php endif; ?>
                                            <button type="submit" class="booking-action-btn btn-book-car-only w-50">
                                                Skip & Book Property Only
                                            </button>
                                
                                        <!--</form>-->
                                        <button type="button" onclick="scrollToPropertySection()" name="choose_property" class="booking-action-btn btn-book-car-property w-50">
                                            Book Property with Car
                                        </button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </aside>
                </div>
            </div>

        </div>
    </div>
</div>


<div class="package-wrapper pt-3"  id="property-content">
    <div class="container" >
        
        

        <div class="row">
            <?php while ($car_display = mysqli_fetch_array($spot_fetch)) { 
                $carImgPath = 'admin/dashboard/' . $car_display['car_img'];
                $fallbackImg = 'assets/images/resort.jpg';
                if (empty($car_display['car_img']) || !file_exists($carImgPath)) {
                    $carImgPath = $fallbackImg;
                }
            ?>
                <div class="col-lg-4 mb-4">
                    <div class="package-card-alpha">
                        <div class="package-thumb">
                            <a href="<?php echo $carImgPath; ?>" data-fancybox="gallery" data-caption="Caption Here" class="gallary-item-overlay">
                                <img src="<?php echo $carImgPath; ?>" alt="Gallery Image" style="height: 200px;">
                            </a>
                            <p class="card-lavel">
                                <i class="fa-solid fa-person"></i>
                                <span>MaxSeat <?php echo $car_display['maxSeat'] ?></span>
                            </p>
                        </div>

                        <div class="package-card-body">
                            <h3 class="p-card-title"><?php echo $car_display['car_name'] ?></h3>
                            <h5><?php echo $car_display['spotA_name'] ?> to <?php echo $car_display['spotB_name'] ?></h5>
                            <div class="p-card-bottom">
                                <div class="book-btn">
                                    <button 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#carBookingModal" 
                                       
                                        data-car-id="<?php echo $car_display['carId']; ?>" 
                                        data-car-name="<?php echo htmlspecialchars($car_display['car_name']); ?>" 
                                        data-price="<?php echo $car_display['price']; ?>"
                                        data-scene-price="<?php echo $car_display['scenePrice']; ?>"
                                        data-sidescene="<?php echo htmlspecialchars($car_display['sideScene']); ?>"
                                        data-spotA="<?php echo htmlspecialchars($car_display['spotA_name']); ?>"
                                        data-spotB="<?php echo htmlspecialchars($car_display['spotB_name']); ?>"
                                    >
                                        Book Now <i class='bx bxs-right-arrow-alt'></i>
                                    </button>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <form action="checkout.php" method="post" class="text-center mb-3">
            <?php if (isset($_SESSION['property_booking'])): ?>
                <input type="hidden" name="hotel_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['property_booking'])); ?>">
            <?php endif; ?>
            <button type="submit" class="btn-skip-modern">
                Skip Car Booking <i class="fa-solid fa-arrow-right ms-2"></i>
            </button>

        </form>
    </div>
</div>

<!-- Booking Modal -->
<div class="modal fade" id="carBookingModal" tabindex="-1" aria-labelledby="carBookingModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
        <div class="col-lg-12">
          <div class="package-sidebar">
            <aside class="package-widget-style-2 widget-form mt-3">
              <div class="widget-title text-center d-flex justify-content-between">
                <h4>Book This Car</h4>
                <h3 class="widget-lavel ms-4">
                  <span>Rent Price:</span> ₹<span id="modalRentPrice"></span>
                </h3>
              </div>
              <div class="widget-body mb-4">
                <form action="checkout.php" method="post" id="booking-form">
               
                    <?php if (isset($_SESSION['property_booking'])): ?>
                      <input type="hidden" name="hotel_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['property_booking'])); ?>">
                    <?php endif; ?>

                  <div class="booking-form-wrapper">
                    <input type="hidden" name="carId" id="modalCarId">
                    <input type="hidden" name="price" id="modalPrice">
                    <input type="hidden" name="scenePrice" id="modalScenePrice">
                    <input type="hidden" name="full_name" placeholder="Your Full Name" required value="<?php echo $_POST['name'] ?>">
                    <input type="hidden" name="email" placeholder="Your Email" required value="<?php echo $_POST['email'] ?>">
                    <input type="hidden" name="phone" placeholder="Phone" required value="<?php echo $_POST['phone'] ?>">
                    <input type="hidden" name="total_amount" id="totalAmount">
                    
                    <div class="row">
                        <div class="col-12 custom-input-group">
                            <label>Date</label>
                          <input type="date" name="starting_date" required>
                        </div>
                    </div>
                    <div class="border border-warning rounded p-3 mt-3 bg-light-subtle shadow-sm">
                        <div class="form-check d-flex align-items-center">
                            <input class="form-check-input me-2" type="checkbox" name="visit-site-scene" id="visit-site-scene">
                            <label class="form-check-label fw-bold text-dark" for="visit-site-scene">
                                Want to add sightseeing? 
                                <span class="badge bg-warning text-dark ms-2">+ ₹<span id="scenePriceDisplay"></span></span>
                            </label>
                        </div>
                    
                        <!-- Site scene details input (shown only if checked) -->
                        <div class="custom-input-group mt-3" id="sceneInputGroup" style="display: none;">
                            <label for="site-scene-details" class="form-label">sightseeing Details</label>
                            <input 
                                type="text" 
                                name="site_scene_details" 
                                placeholder="Enter site scene details"
                                id="siteSceneDetails"
                                readonly 
                                class="form-control bg-white"
                            >
                        </div>
                    </div>
                    <div class="row">
                        <!-- Start spot -->
                        <div class="col-6 custom-input-group">
                            <input type="text" name="spotA" id="spotA" readonly>
                        </div>
    
                        <!-- End spot -->
                        <div class="col-6 custom-input-group">
                            <input type="text" name="spotB" id="spotB" readonly>
                        </div>
                    </div>

                    <div class="custom-input-group">
                      <div class="submite-btn">
                        <button type="submit" name="book_car_now">Book Now</button>
                      </div>
                    </div>

                  </div>
                </form>
              </div>
            </aside>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include('./resources/footer.php'); ?>
<script>
    function scrollToPropertySection() {
        const target = document.getElementById('property-content');
        if (target) {
            target.scrollIntoView({ behavior: 'smooth' });
        }
    }
</script>
<script>
const carBookingModal = document.getElementById('carBookingModal');

carBookingModal.addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;
    
    // Get references
    const modalCarId = document.getElementById('modalCarId');
    const modalPrice = document.getElementById('modalPrice');
    const modalScenePrice = document.getElementById('modalScenePrice');
    const spotA = document.getElementById('spotA');
    const spotB = document.getElementById('spotB');
    const rentDisplay = document.getElementById('modalRentPrice');
    const sceneDetails = document.getElementById('siteSceneDetails');
    const scenePriceDisplay = document.getElementById('scenePriceDisplay');
    const visitSceneCheckbox = document.getElementById('visit-site-scene');

    // Set values from button
    modalCarId.value = button.getAttribute('data-car-id');
    modalPrice.value = button.getAttribute('data-price');
    modalScenePrice.value = button.getAttribute('data-scene-price');
    spotA.value = button.getAttribute('data-spota');
    spotB.value = button.getAttribute('data-spotb');
    sceneDetails.value = button.getAttribute('data-sidescene') || 'None';

    // Update displayed scene price
    const scenePrice = parseFloat(button.getAttribute('data-scene-price')) || 0;
    scenePriceDisplay.textContent = scenePrice;

    // Reset checkbox and section on modal show
    visitSceneCheckbox.checked = false;
    document.getElementById('sceneInputGroup').style.display = 'none';

    // Display base rent price
    const basePrice = parseFloat(button.getAttribute('data-price')) || 0;
    rentDisplay.textContent = basePrice;
    document.getElementById('totalAmount').value = basePrice;
});

// Toggle site scene input + update rent price
document.getElementById('visit-site-scene').addEventListener('change', function () {
    const sceneInput = document.getElementById('sceneInputGroup');
    const rentDisplay = document.getElementById('modalRentPrice');
    const basePrice = parseFloat(document.getElementById('modalPrice').value) || 0;
    const scenePrice = parseFloat(document.getElementById('modalScenePrice').value) || 0;
    const totalAmountField = document.getElementById('totalAmount');

    sceneInput.style.display = this.checked ? 'block' : 'none';

    // Update displayed rent price
    rentDisplay.textContent = this.checked ? (basePrice + scenePrice) : basePrice;
    const total = this.checked ? basePrice + scenePrice : basePrice;
    document.getElementById('totalAmount').value = total;
});
</script>

<script>
// const carBookingModal = document.getElementById('carBookingModal');

// carBookingModal.addEventListener('show.bs.modal', function (event) {
//     const button = event.relatedTarget;

//     // Make sure these exist before trying to use them
//     document.getElementById('modalCarId').value = button.getAttribute('data-car-id');
//     document.getElementById('modalPrice').value = button.getAttribute('data-price');
//     document.getElementById('modalScenePrice').value = button.getAttribute('data-scene-price');

//     document.getElementById('spotA').value = button.getAttribute('data-spota');
//     document.getElementById('spotB').value = button.getAttribute('data-spotb');

//     // Update rent price display
//     // document.getElementById('modalRentPrice').textContent = button.getAttribute('data-price');
//     // Set Site Scene Details
//     const sceneDetails = button.getAttribute('data-sidescene') || 'None';
//     document.getElementById('siteSceneDetails').value = sceneDetails;

//     // Optional: update rent price display
//     const rentDisplay = document.getElementById('modalRentPrice');
//     if (rentDisplay) {
//         rentDisplay.textContent = button.getAttribute('data-price');
//     }
// });
// document.getElementById('visit-site-scene').addEventListener('change', function () {
//     const sceneInput = document.getElementById('sceneInputGroup');
//     sceneInput.style.display = this.checked ? 'block' : 'none';
// });

</script>
