<?php
include('resources/header.php');

$searchTerm = isset($_GET['phoneSearch']) ? trim(mysqli_real_escape_string($conn, $_GET['phoneSearch'])) : '';
$isSearch = !empty($searchTerm);

$packageBookings = $propertyBookings = $carBookings = [];

if ($isSearch) {
    $packageBookingsQuery = "
        SELECT pb.*, i.invoice_number 
        FROM package_bookings pb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('package_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(pb.id, i.booking_id) > 0
        WHERE pb.phone LIKE '$searchTerm'
        ORDER BY pb.id DESC
    ";

    $packageBookings = mysqli_query($conn, $packageBookingsQuery);
// echo $packageBookingsQuery;
    $propertyBookingsQuery = "
        SELECT pb.*, i.invoice_number 
        FROM property_bookings pb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('property_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(pb.id, i.booking_id) > 0
        WHERE pb.phone LIKE '$searchTerm'
        ORDER BY pb.id DESC
    ";

    $propertyBookings = mysqli_query($conn, $propertyBookingsQuery);
// echo $propertyBookingsQuery;
    $carBookingsQuery = "
        SELECT cb.*, i.invoice_number 
        FROM car_bookings cb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('car_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(cb.id, i.booking_id) > 0
        WHERE cb.phone LIKE '$searchTerm'
        ORDER BY cb.id DESC
    ";

    $carBookings = mysqli_query($conn, $carBookingsQuery);
// echo $carBookingsQuery;
}
?>

<style>
@media only screen and (max-width: 767px) {
    .responsive-table-wrapper {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    table {
        width: 100%;
        min-width: 600px;
        border-collapse: collapse;
    }

    table th, table td {
        white-space: nowrap;
    }
}
</style>

    <div class="container mt-5">
        <h2 class="text-center mb-4">All Bookings</h2>
        <div class="mb-3">
        <form id="otpRequestForm" class="row g-2 align-items-stretch" method="POST">
            <div class="col-10">
                <input type="text" id="phoneSearch" name="phoneSearch" class="form-control" placeholder="Enter your phone number to verify and see the results" value="<?= htmlspecialchars($searchTerm) ?>" required />
                <div id="phoneErrorMsg" class="text-danger mt-1" style="font-size: 0.875rem;"></div>
            </div>
            <div class="col-2 d-grid">
                <button type="submit" class="btn btn-primary h-100">Send OTP</button>
            </div>
        </form>
    </div>
    <div class="modal fade" id="otpModal" tabindex="-1" aria-labelledby="otpModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <form id="verifyOtpForm">
            <div class="modal-header">
              <h5 class="modal-title" id="otpModalLabel">Enter OTP</h5>
            </div>
            <div class="modal-body">
              <input type="text" class="form-control" id="otpInput" name="otp" placeholder="Enter OTP" required>
              <input type="hidden" id="hiddenPhone" name="phone" />
            </div>
            <div class="modal-footer">
              <button type="submit" class="btn btn-success">Verify</button>
            </div>
          </form>
        </div>
      </div>
    </div>



    <ul class="nav nav-tabs" id="bookingTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="package-tab" data-bs-toggle="tab" data-bs-target="#package" type="button" role="tab">Package Bookings</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="property-tab" data-bs-toggle="tab" data-bs-target="#property" type="button" role="tab">Property Bookings</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="car-tab" data-bs-toggle="tab" data-bs-target="#car" type="button" role="tab">Car Bookings</button>
        </li>
    </ul>

    <div class="tab-content mt-3" id="bookingTabsContent">
        <!-- Package Bookings -->
        <div class="tab-pane fade show active responsive-table-wrapper" id="package" role="tabpanel">
            <?php if ($isSearch): ?>
                <?php if (mysqli_num_rows($packageBookings) > 0): ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th><th>Invoice No</th><th>Name</th><th>Email</th><th>Phone</th>
                                <th>Total</th><th>Date</th><th>Status</th><th>Invoice</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; while($row = mysqli_fetch_assoc($packageBookings)) { ?>
                            <tr class="booking-item">
                                <td><?= $i++ ?></td>
                                <td><?= $row['invoice_number'] ?? '-' ?></td>
                                <td><?= htmlspecialchars($row['full_name']) ?></td>
                                <td><?= htmlspecialchars($row['email']) ?></td>
                                <td><?= htmlspecialchars($row['phone']) ?></td>
                                <td>₹<?= $row['total_amount'] ?></td>
                                <td><?= $row['booking_date'] ?></td>
                                <td><span class="badge bg-secondary"><?= $row['status'] ?></span></td>
                                <td><a href="invoice/index.php?id=<?= $row['invoice_number'] ?>" class="badge bg-warning text-dark"><i class="bi bi-receipt"></i></a></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="text-center py-5 text-muted">No data found.</div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5 text-muted">Please search to see results.</div>
            <?php endif; ?>
        </div>

        <!-- Property Bookings -->
        <div class="tab-pane fade responsive-table-wrapper" id="property" role="tabpanel">
            <?php if ($isSearch): ?>
                <?php if (mysqli_num_rows($propertyBookings) > 0): ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th><th>Invoice No</th><th>Name</th><th>Email</th><th>Phone</th><th>Rooms</th><th>Total</th><th>Status</th><th>Invoice</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; while($row = mysqli_fetch_assoc($propertyBookings)) { ?>
                            <tr class="booking-item">
                                <td><?= $i++ ?></td>
                                <td><?= $row['invoice_number'] ?? '-' ?></td>
                                <td><?= htmlspecialchars($row['name']) ?></td>
                                <td><?= htmlspecialchars($row['email']) ?></td>
                                <td><?= htmlspecialchars($row['phone']) ?></td>
                                <td><?= $row['number_of_rooms'] ?></td>
                                <td>₹<?= $row['total_amount'] ?></td>
                                <td><span class="badge bg-secondary"><?= $row['status'] ?></span></td>
                                <td><a href="invoice/index.php?id=<?= $row['invoice_number'] ?>" class="badge bg-warning text-dark"><i class="bi bi-receipt"></i></a></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="text-center py-5 text-muted">No data found.</div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5 text-muted">Please search to see results.</div>
            <?php endif; ?>
        </div>

        <!-- Car Bookings -->
        <div class="tab-pane fade responsive-table-wrapper" id="car" role="tabpanel">
            <?php if ($isSearch): ?>
                <?php if (mysqli_num_rows($carBookings) > 0): ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th><th>Invoice No</th><th>Name</th><th>Email</th><th>Phone</th><th>Visit Site</th><th>Total</th><th>Status</th><th>Invoice</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i=1; while($row = mysqli_fetch_assoc($carBookings)) { ?>
                            <tr class="booking-item">
                                <td><?= $i++ ?></td>
                                <td><?= $row['invoice_number'] ?? '-' ?></td>
                                <td><?= htmlspecialchars($row['full_name']) ?></td>
                                <td><?= htmlspecialchars($row['email']) ?></td>
                                <td><?= htmlspecialchars($row['phone']) ?></td>
                                <td><?= $row['visit_site_scene'] ? 'Yes' : 'No' ?></td>
                                <td>₹<?= $row['total_amount'] ?></td>
                                <td><span class="badge bg-secondary"><?= $row['status'] ?></span></td>
                                <td><a href="invoice/index.php?id=<?= $row['invoice_number'] ?>" class="badge bg-warning text-dark"><i class="bi bi-receipt"></i></a></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <div class="text-center py-5 text-muted">No data found.</div>
                <?php endif; ?>
            <?php else: ?>
                <div class="text-center py-5 text-muted">Please search to see results.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include('resources/footer.php'); ?>
<script>
document.getElementById("otpRequestForm").addEventListener("submit", function(e) {
    e.preventDefault();
    const phone = document.getElementById("phoneSearch").value;
    const errorMsgDiv = document.getElementById("phoneErrorMsg");
    errorMsgDiv.textContent = "";
    // validate phone number: must be exactly 10 digits
    if (!/^\d{10}$/.test(phone)) {
        errorMsgDiv.textContent = "Please enter a valid 10-digit phone number.";
        return;
    }

    fetch("send_otp.php", {
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: "phone=" + encodeURIComponent(phone)
    }).then(res => res.text()).then(response => {
        if (response === "sent") {
            document.getElementById("hiddenPhone").value = phone;
            new bootstrap.Modal(document.getElementById("otpModal")).show();
        } else {
            alert("Failed to send OTP.");
        }
    });
});

document.getElementById("verifyOtpForm").addEventListener("submit", function(e) {
    e.preventDefault();
    const otp = document.getElementById("otpInput").value;
    const phone = document.getElementById("hiddenPhone").value;

    fetch("verify_otp.php", {
        method: "POST",
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: "otp=" + encodeURIComponent(otp) + "&phone=" + encodeURIComponent(phone)
    }).then(res => res.text()).then(response => {
        if (response === "verified") {
            window.location.href = "?phoneSearch=" + encodeURIComponent(phone);
        } else {
            alert("Invalid OTP");
        }
    });
});
</script>
