<?php include('./resources/header.php'); ?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Add Tour Spot</h3>
            </div>
            <div class="block-content">
                <form class="mb-4" action="insert_Action.php" method="POST" enctype="multipart/form-data">
                    <div class="row push mx-1 mx-md-4">
                        <!-- State Dropdown -->
                        <div class="col-lg-6 col-md-6 col-sm-12 mb-3">
                            <label class="form-label" for="state">Select State</label>
                             <select class="form-select w-100 " id="state" name="state" required>
                        <option value="">Open this select menu</option>
                        <!-- All states and UTs here -->
                        <option value="Andhra Pradesh">Andhra Pradesh</option>
                        <option value="Andaman and Nicobar Islands">Andaman and Nicobar Islands</option>
                        <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                        <option value="Assam">Assam</option>
                        <option value="Bihar">Bihar</option>
                        <option value="Chandigarh">Chandigarh</option>
                        <option value="Chhattisgarh">Chhattisgarh</option>
                        <option value="Dadra and Nagar Haveli and Daman and Diu">Dadra and Nagar Haveli and Daman and Diu</option>
                        <option value="Delhi">Delhi</option>
                        <option value="Goa">Goa</option>
                        <option value="Gujarat">Gujarat</option>
                        <option value="Haryana">Haryana</option>
                        <option value="Himachal Pradesh">Himachal Pradesh</option>
                        <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                        <option value="Jharkhand">Jharkhand</option>
                        <option value="Karnataka">Karnataka</option>
                        <option value="Kerala">Kerala</option>
                        <option value="Ladakh">Ladakh</option>
                        <option value="Lakshadweep">Lakshadweep</option>
                        <option value="Madhya Pradesh">Madhya Pradesh</option>
                        <option value="Maharashtra">Maharashtra</option>
                        <option value="Manipur">Manipur</option>
                        <option value="Meghalaya">Meghalaya</option>
                        <option value="Mizoram">Mizoram</option>
                        <option value="Nagaland">Nagaland</option>
                        <option value="Odisha">Odisha</option>
                        <option value="Punjab">Punjab</option>
                        <option value="Puducherry">Puducherry</option>
                        <option value="Rajasthan">Rajasthan</option>
                        <option value="Sikkim">Sikkim</option>
                        <option value="Tamil Nadu">Tamil Nadu</option>
                        <option value="Telangana">Telangana</option>
                        <option value="Tripura">Tripura</option>
                        <option value="Uttar Pradesh">Uttar Pradesh</option>
                        <option value="Uttarakhand">Uttarakhand</option>
                        <option value="West Bengal">West Bengal</option>
                    </select>
                        </div>

                        <!-- Spot Fields -->
                        <div id="spot-fields" class="col-lg-6 col-md-6 col-sm-12 mb-3">
                            <label class="form-label">Spot name(s)</label>
                            <div class="input-group mb-2 spot-group">
                                <input type="text" class="form-control" name="spot_name[]" placeholder="Enter spot name.." required>
                                <button type="button" class="btn btn-danger remove-btn" disabled>&times;</button>
                            </div>
                            <button type="button" id="add-spot" class="btn btn-success btn-sm">+ Add</button>
                        </div>

                        <!-- Submit Button -->
                        <div class="col-12 text-center mt-4">
                            <button type="submit" name="tour_submit" value="tour_submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<?php include('./resources/footer.php'); ?>
<!-- Script to handle dynamic addition/removal -->
<script>
    const spotFields = document.getElementById('spot-fields');
    const addSpotBtn = document.getElementById('add-spot');

    function createSpotInput() {
        const group = document.createElement('div');
        group.className = 'input-group mb-2 spot-group';

        const input = document.createElement('input');
        input.type = 'text';
        input.name = 'spot_name[]';
        input.className = 'form-control';
        input.placeholder = 'Enter spot name..';
        input.required = true;

        const removeBtn = document.createElement('button');
        removeBtn.type = 'button';
        removeBtn.className = 'btn btn-danger remove-btn';
        removeBtn.innerHTML = '&times;';
        removeBtn.addEventListener('click', function () {
            if (spotFields.querySelectorAll('.spot-group').length > 1) {
                group.remove();
            }
            toggleRemoveButtons();
        });

        group.appendChild(input);
        group.appendChild(removeBtn);

        return group;
    }

    addSpotBtn.addEventListener('click', () => {
        spotFields.insertBefore(createSpotInput(), addSpotBtn);
        toggleRemoveButtons();
    });

    function toggleRemoveButtons() {
        const groups = spotFields.querySelectorAll('.spot-group');
        const allRemoveBtns = spotFields.querySelectorAll('.remove-btn');
        allRemoveBtns.forEach(btn => btn.disabled = (groups.length <= 1));
    }

    toggleRemoveButtons();
</script>