<?php
include('./config/dbcon.php');

// Enable full error reporting
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);


function escape_special_chars($string) {
    return addslashes($string);
}
if (isset($_POST['submit'])) {
    $property_type       = trim($_POST['property_type']);
    $property_name       = trim($_POST['name']);
    $short_description   = escape_special_chars($_POST['short_description']);
    $full_description    = escape_special_chars($_POST['full_description']);
    $manager_name        = trim($_POST['manager_name']);
    $email               = trim($_POST['email']);
    $phoneNo             = trim($_POST['phoneNo']);
    $altPhoneNo          = trim($_POST['altPhoneNo']);
    $street              = trim($_POST['street']);
    $city                = trim($_POST['city']);
    $state               = trim($_POST['state']);
    $pin                 = trim($_POST['pin']);
    $country             = trim($_POST['country']);
    $tour_spot           = trim($_POST['tour_spot']);

    // Optional checkbox values (set default to "No" if not selected)
    $wifi           = isset($_POST['wifi']) ? $_POST['wifi'] : 'No';
    $parking        = isset($_POST['parking']) ? $_POST['parking'] : 'No';
    $breakfast      = isset($_POST['breakfast']) ? $_POST['breakfast'] : 'No';
    $pool           = isset($_POST['pool']) ? $_POST['pool'] : 'No';
    $garden         = isset($_POST['garden']) ? $_POST['garden'] : 'No';
    $view           = isset($_POST['view']) ? $_POST['view'] : 'No';
    $reception      = isset($_POST['reception']) ? $_POST['reception'] : 'No';
    $housekeeping   = isset($_POST['housekeeping']) ? $_POST['housekeeping'] : 'No';
    $bonfire        = isset($_POST['bonfire']) ? $_POST['bonfire'] : 'No';
    $activities     = isset($_POST['activities']) ? $_POST['activities'] : 'No';
    $games          = isset($_POST['games']) ? $_POST['games'] : 'No';
    $hall           = isset($_POST['hall']) ? $_POST['hall'] : 'No';
    $dinning        = isset($_POST['dinning']) ? $_POST['dinning'] : 'No';
    $kitchen_access = isset($_POST['kitchen_access']) ? $_POST['kitchen_access'] : 'No';
    $pet            = isset($_POST['pet']) ? $_POST['pet'] : 'No';
    $family         = isset($_POST['family']) ? $_POST['family'] : 'No';
    $couple         = isset($_POST['couple']) ? $_POST['couple'] : 'No';
    $wheelchair     = isset($_POST['wheelchair']) ? $_POST['wheelchair'] : 'No';

    // Other fields
    $checkIn             = trim($_POST['checkIn']);
    $checkOut            = trim($_POST['checkOut']);
    $cancellation_policy = trim($_POST['cancellation']);
    $smoking             = trim($_POST['smoking']);
    $pet_policy          = trim($_POST['pet_policy']);
    
    // Payment method is a checkbox array
    $payment_methods     = isset($_POST['payment']) && is_array($_POST['payment']) ? $_POST['payment'] : [];
    $payment_string      = implode(", ", $payment_methods);

    $meta_title          = trim($_POST['meta_title']);
    $meta_description    = escape_special_chars($_POST['meta_description']);
    $tags                = trim($_POST['tags']);
    $status              = trim($_POST['status']);

    // Handle image upload
    $coverImage = $_FILES['cover_image']['name'];
    $coverTmp = $_FILES['cover_image']['tmp_name'];
    $coverNewName = rand(1220, 94578) . '_' . time() . '_' . $coverImage;
    $coverPath = 'upload/' . $coverNewName;

    if (move_uploaded_file($coverTmp, $coverPath)) {
        $coverImage = $coverPath;
    } else {
        $coverImage = ''; // If not uploaded successfully
    }

    // Insert into DB
    $query = "INSERT INTO Hotel_Add (
        property_Type, name, short_Description, full_Description, property_Owner_Name, email, phone_Number, alt_Phone_No,
        street, city, state, pin, country, choose, wifi, parking, breakfast, pool, garden, view, reception, housekeeping,
        bonfire, activities, games, hall, dinning, kitchen_access, pet, family, couple, wheelchair, cover_img, checkIn,
        checkOut, cancellation, smoking, pet_policy, payment, meta_title, meta_description, tags, status
    ) VALUES (
        '$property_type', '$property_name', '$short_description', '$full_description', '$manager_name', '$email', '$phoneNo',
        '$altPhoneNo', '$street', '$city', '$state', '$pin', '$country', '$tour_spot', '$wifi', '$parking', '$breakfast',
        '$pool', '$garden', '$view', '$reception', '$housekeeping', '$bonfire', '$activities', '$games', '$hall', '$dinning',
        '$kitchen_access', '$pet', '$family', '$couple', '$wheelchair', '$coverImage', '$checkIn', '$checkOut',
        '$cancellation_policy', '$smoking', '$pet_policy', '$payment_string', '$meta_title', '$meta_description', '$tags', '$status'
    )";

    $hotel_insert = mysqli_query($conn, $query) or die(mysqli_error($conn));

    if ($hotel_insert) {
        header('location:listOfHotels.php');
        exit();
    } else {
        echo "Unsuccessful";
    }
}


if (isset($_POST['package_submit'])) {
    $package_title       = trim($_POST['package_title']);
    $duration            = trim($_POST['duration']);
    $short_description   = escape_special_chars($_POST['short_description']);
    $full_description    = escape_special_chars($_POST['full_description']);
    $inclusions          = trim($_POST['inclusions']);
    $exclusions          = trim($_POST['exclusions']);
    $person_price        = trim($_POST['person_price']);
    $child_price         = trim($_POST['child_price']);
    $bed                 = isset($_POST['bed']) ? trim($_POST['bed']) : '';
    $group_discount      = isset($_POST['group_discount']) ? trim($_POST['group_discount']) : '';
    
    // ✅ Fix: assign NULL if field is empty or not set
    $group_discount_percent = (isset($_POST['group_discount_percent']) && $_POST['group_discount_percent'] !== '')
        ? (int)$_POST['group_discount_percent']
        : null;

    $custom_quote        = isset($_POST['custom_quote']) ? trim($_POST['custom_quote']) : '';
    $payment             = trim($_POST['payment']);
    $cancellation        = trim($_POST['cancellation']);
    $tags                = trim($_POST['tags']);
    $meta_title          = trim($_POST['meta_title']);
    $meta_description    = escape_special_chars($_POST['meta_description']);
    $url                 = trim($_POST['url']);
    $status              = trim($_POST['status']);
    $feature             = trim($_POST['feature']);

    // Handle multiple image uploads
    $uploadedImages = [];
    if (!empty($_FILES['package_image']['name'][0])) {
        foreach ($_FILES['package_image']['name'] as $key => $name) {
            $tmpName = $_FILES['package_image']['tmp_name'][$key];
            $imgExt = strtolower(pathinfo($name, PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'webp', 'gif', 'avif'];

            if (in_array($imgExt, $allowed)) {
                $uniqueName = rand(12202, 95775) . '_' . time() . '_' . basename($name);
                $uploadPath = 'upload/' . $uniqueName;

                if (move_uploaded_file($tmpName, $uploadPath)) {
                    $uploadedImages[] = $uploadPath;
                }
            }
        }
    }

    // Convert array to JSON for DB storage
    $image_json = json_encode($uploadedImages);

    // ✅ Safe SQL insert (handles NULL properly for discount)
    $insert_query = mysqli_query($conn, "INSERT INTO add_package (
        package_title,
        duration,
        short_description,
        detailed_itinerary,
        inclusions,
        exclusions,
        person_price,
        child_price,
        bed,
        group_discount,
        discount,
        custom_quote,
        payment_terms,
        cancellation,
        tags,
        meta_title,
        meta_description,
        slug,
        status,
        feature,
        package_image
    ) VALUES (
        '$package_title',
        '$duration',
        '$short_description',
        '$full_description',
        '$inclusions',
        '$exclusions',
        '$person_price',
        '$child_price',
        '$bed',
        '$group_discount',
        " . ($group_discount_percent === null ? "NULL" : $group_discount_percent) . ",
        '$custom_quote',
        '$payment',
        '$cancellation',
        '$tags',
        '$meta_title',
        '$meta_description',
        '$url',
        '$status',
        '$feature',
        '$image_json'
    )") or die(mysqli_error($conn));

    if ($insert_query) {
        header('Location: listOfPackages.php');
        exit();
    } else {
        echo "Insertion failed.";
    }
}

if(isset($_POST['room_submit']))
{
    $property_name=$_POST['property_name'];
    $room_name=$_POST['room_name'];
    $room_descr=$_POST['room_descr'];
    $room_size=$_POST['room_size'];
    $occupancy=$_POST['occupancy'];
    $extra_person=$_POST['extra_person'];
    $price=$_POST['price'];
    $discount=$_POST['discount'];
    $cleaning_fee=$_POST['cleaning_fee'];
    $attached_bathroom=$_POST['attached_bathroom'];
    $ac=$_POST['ac'];
    $heater=$_POST['heater'];
    $tv=$_POST['tv'];
    $geyser=$_POST['geyser'];
    $kitchen=$_POST['kitchen'];
    $towels=$_POST['towels'];
    $garden_view=$_POST['garden_view'];
    $wardrobe=$_POST['wardrobe'];
    $deskChair=$_POST['deskChair'];
    $mini_Fridge=$_POST['mini_Fridge'];
    $room_service=$_POST['room_service'];
    $publicOrPrivate=$_POST['publicOrPrivate'];
    
    $coverImage = $_FILES['room_image']['name'];
    $coverTmp = $_FILES['room_image']['tmp_name'];
    $coverNewName = rand(12202, 95775) . '_' . time() . '_' . $coverImage;
    $coverPath = 'upload/'. $coverNewName;

    if (move_uploaded_file($coverTmp, $coverPath)) {
        $roomImage = $coverPath;
    }
    
    $room_insert = "
        INSERT INTO room_details (
           
            hotel_id,
            room_name,
            room_description,
            room_size,
            occupancy,
            extra_person,
            extra_charges,
            price_per_night,
            discount,
            cleaning_fee,
            attached_bathroom,
            ac,
            heater,
            tv,
            	geyser,
            	kitchen,
            	towels,
            	garden_view,
            	wardrobe,
            	deskChair,
            	mini_Fridge,
            	room_service,
            	room_img,
            	public_Or_Private
        ) VALUES (
            '$property_name',
            '$room_name',
            '$room_descr',
            '$room_size',
            '$occupancy',
            '$extra_person',
            '$extra_charges',
            '$price',
            '$discount',
            '$cleaning_fee',
            '$attached_bathroom',
            '$ac',
            '$heater',
            '$tv',
            '$geyser',
            '$kitchen',
            '$towels',
            '$garden_view',
            '$wardrobe',
            '$deskChair',
            '$mini_Fridge',
             '$room_service',
             '$roomImage',
             '$publicOrPrivate'
             
        )
    ";
    
    if (mysqli_query($conn, $room_insert)) {
        header('Location: listOfRooms.php');
        exit;
    }
}


if (isset($_POST['tour_submit'])) {
    $state = $_POST['state'];
    $spots = $_POST['spot_name'];  // Directly access the array without []

    // Check if the state already exists
    $check_state = mysqli_query($conn, "SELECT id FROM tours WHERE state = '$state'");
    
    if (mysqli_num_rows($check_state) > 0) {
        $row = mysqli_fetch_assoc($check_state);
        $tour_id = $row['id'];
    } else {
        // Insert the new state
        $tour_insert = mysqli_query($conn, "INSERT INTO tours (state) VALUES ('$state')");
        if ($tour_insert) {
            $tour_id = mysqli_insert_id($conn);
        } else {
            echo "Failed to insert tour.";
            exit;
        }
    }
    
    foreach ($spots as $spot) {
        $spot_insert = mysqli_query($conn, "INSERT INTO spots (tour_id, spot) VALUES ('$tour_id', '$spot')");
    }

    // Check if spots were inserted successfully
    if ($spot_insert) {
        header('location:listOfSpots.php');
    } else {
        echo "Unsuccessful in inserting spots.";
    }
    
    // // Insert the tour details
    // $tour_insert = mysqli_query($conn, "INSERT INTO tours (state) VALUES ('$state')");

    // if ($tour_insert) {
    //     // Get the last inserted tour ID
    //     $tour_id = mysqli_insert_id($conn);

    //     // Loop through the spots and insert each one
    //     foreach ($spots as $spot) {
    //         $spot_insert = mysqli_query($conn, "INSERT INTO spots (tour_id, spot) VALUES ('$tour_id', '$spot')");
    //     }

    //     // Check if spots were inserted successfully
    //     if ($spot_insert) {
    //         header('location:listOfSpots.php');
    //     } else {
    //         echo "Unsuccessful in inserting spots.";
    //     }
    // } else {
    //     echo "Unsuccessful in inserting tour.";
    // }
}


?>