<?php
include('./config/dbcon.php');
include('./resources/header.php');
$room_id=$_REQUEST['ep'];
$joining_query=mysqli_query($conn,"SELECT 
    Hotel_Add.name AS property_name, 
    room_details.*
FROM 
    room_details
JOIN 
    Hotel_Add ON Hotel_Add.hotel_id = room_details.hotel_id WHERE roomId='$room_id'");

$sql_fetch=mysqli_fetch_assoc($joining_query);
   
$property_name_query=mysqli_query($conn,"SELECT * FROM Hotel_Add");

?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Edit Room Details</h3>
            </div>
            <div class="block-content">
                <form class="mb-4" action="edit_Action.php" method="POST" enctype="multipart/form-data">
                    <h2 class="content-heading">Basic Information</h2>

                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="status">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1"<?php if($sql_fetch['status']=="1")echo 'selected="selected"'?>>Active</option>
                                    <option value="0"<?php if($sql_fetch['name']=="0")echo 'selected="selected"'?>>Inactive</option>
                                   
                                </select>
                            </div>
                          <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="property_type">Property name</label>
                                
                                
                                <?php $property_name = $sql_fetch['hotel_id']; ?>
                                <select class="form-select" id="property_name" name="property_name">
                                    
                                    <?php
                                     while ($row = mysqli_fetch_assoc($property_name_query)) {
                                        $selected = ($row['hotel_id'] == $property_name) ? 'selected' : '';
                                        echo '<option value="' . $row['hotel_id'] . '" ' . $selected . '>' . htmlspecialchars($row['name']) . '</option>';
                                    }
                                ?>
                                </select>
                            
                            </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="property_type">Edit Room Name.</label>
                                <input type="text" class="form-control" id="room_id" name="room_id" value="<?php echo $room_id?>"hidden/>
                                <input type="text" class="form-control" id="room_name" name="room_name" placeholder="Enter Room Name.." value="<?php echo $sql_fetch['room_name']?>">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="fDescription">Edit Room Size(in Sq.ft.)</label>
                                     <input type="number" class="form-control" id="room_size" name="room_size" placeholder="Enter Room Size.." value="<?php echo $sql_fetch['room_size']?>">
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="rDescription">Edit Room Description</label>
                                    <textarea class="form-control" id="room_descr" name="room_descr" placeholder="Enter Room Description.."><?php echo $sql_fetch['room_description']?></textarea>
                            </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="occupancy">Edit Room Occupancy</label>
                                <input type="number" class="form-control" id="occupancy" name="occupancy" placeholder="Enter Occupancy.." value="<?php echo $sql_fetch['occupancy']?>">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="email">Extra_Person</label>
                                <input type="number" class="form-control" id="extra_person" name="extra_person" placeholder="Enter Extra Person.." value="<?php echo $sql_fetch['extra_person']?>">
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Prices</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                             <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="extra_charges">Extra Charges</label>
                                <input type="number" class="form-control" id="extra_charges" name="extra_charges" placeholder="Enter Extra Charges.." value="<?php echo $sql_fetch['extra_charges']?>">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="price">Price per Night</label>
                                <input type="number" class="form-control" id="price" name="price" placeholder="Enter Price per Night.." value="<?php echo $sql_fetch['price_per_night']?>">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="name"> New Discount</label>
                                <input type="number" class="form-control" id="discount" name="discount" placeholder="Enter Discount.." value="<?php echo $sql_fetch['discount']?>">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="name"> New Cleaning Fee</label>
                                <input type="number" class="form-control" id="cleaning_fee" name="cleaning_fee" placeholder="Enter Cleaning fee.." value="<?php echo $sql_fetch['cleaning_fee']?>">
                            </div>
                            
                            
                        </div>
                    </div>
                    <h2 class="content-heading">Update Room Features/Facilities</h2>
                    <div class="row push mx-4">
                        <div class="col-12 overflow-hidden">
                            <div class="mb-4">
                                <div class="space-y-2">
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="attached_bathroom" name="attached_bathroom" value="attached_bathroom" <?php if($sql_fetch['attached_bathroom'] == 'attached_bathroom') echo 'checked'; ?>>
                                        <label class="form-check-label" for="attached_bathroom">Attached Bathroom</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="ac" name="ac" value="ac" <?php if($sql_fetch['ac'] == 'ac') echo 'checked'; ?>>
                                        <label class="form-check-label" for="ac">Air Conditioner</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="heater" name="heater" value="heater" <?php if($sql_fetch['heater'] == 'heater') echo 'checked'; ?>>
                                        <label class="form-check-label" for="heater">Heater</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="tv" name="tv" value="tv" <?php if($sql_fetch['tv'] == 'tv') echo 'checked'; ?>>
                                        <label class="form-check-label" for="tv">Television</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="geyser" name="geyser" value="geyser" <?php if($sql_fetch['geyser'] == 'geyser') echo 'checked'; ?>>
                                        <label class="form-check-label" for="geyser">Geyser</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="kitchen" name="kitchen" value="kitchen" <?php if($sql_fetch['kitchen'] == 'kitchen') echo 'checked'; ?>>
                                        <label class="form-check-label" for="kitchen">Kitchen</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" id="towels" name="towels" value="towels" <?php if($sql_fetch['towels'] == 'towels') echo 'checked'; ?>>
                                        <label class="form-check-label" for="towels">Towels</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" value="garden_view" id="garden_view" name="garden_view" <?php if($sql_fetch['garden_view'] == 'garden_view') echo 'checked'; ?>>
                                        <label class="form-check-label" for="garden_view">Garden View</label>
                                    </div>
                                    <div class="form-check col-3">
                                        <input class="form-check-input" type="checkbox" value="wardrobe" id="wardrobe" name="wardrobe" <?php if($sql_fetch['wardrobe'] == 'wardrobe') echo 'checked'; ?>>
                                        <label class="form-check-label" for="wardrobe">Wardrobe</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="deskChair" id="deskChair" name="deskChair" <?php if($sql_fetch['deskChair'] == 'deskChair') echo 'checked'; ?>>
                                        <label class="form-check-label" for="deskChair">DeskChair</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="mini_Fridge" id="mini_Fridge" name="mini_Fridge" <?php if($sql_fetch['mini_Fridge'] == 'mini_Fridge') echo 'checked'; ?>>
                                        <label class="form-check-label" for="mini_Fridge">Mini Fridge</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="room_service" id="room_service" name="room_service" <?php if($sql_fetch['room_service'] == 'room_service') echo 'checked'; ?>>
                                        <label class="form-check-label" for="room_service">Room_Service</label>
                                    </div>
                                    
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="publicOrPrivate" id="public_Or_Private" name="public_Or_Private" <?php if($sql_fetch['public_Or_Private'] == 'public_Or_Private') echo 'checked'; ?>>
                                        <label class="form-check-label" for="publicOrPrivate">Public or Private</label>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Images</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="cover_image">Room Image</label>
                                <input class="form-control" type="file" id="room_image" name="room_image" style=""> 
                                <input type="hidden" name="prev_img" value="<?php echo $sql_fetch['room_img']; ?>">
                                <?php echo "<img src='".$sql_fetch['room_img']."'height='100' width='100'>"?>
                            </div>
                        </div>
                    </div>
                    <div class="mb-4 col-lg-4 col-sm-12 p-5">
                        <button type="submit" name="room_submit" value="room_submit" class="btn btn-primary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let roomCounter = 2;
        const roomDetailsContainer = document.getElementById('room_details_container');
        const addRoomButton = document.getElementById('add_room_button');

        addRoomButton.addEventListener('click', function() {
            const newRoomBlock = document.createElement('div');
            newRoomBlock.classList.add('block', 'block-rounded', 'mb-4');
            newRoomBlock.innerHTML = `
                <div class="block-header block-header-default">
                    <h3 class="block-title">Room ${roomCounter}</h3>
                </div>
                <div class="block-content">
                    <div class="mb-4">
                        <label class="form-label">Basic Info.</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_name_${roomCounter}">Room Name</label>
                        <input type="text" class="form-control" id="room_name_${roomCounter}" name="room[${roomCounter}][name]" placeholder="Enter room name">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_description_${roomCounter}">Room Description</label>
                        <input type="text" class="form-control" id="room_description_${roomCounter}" name="room[${roomCounter}][description]" placeholder="Enter room description">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_size_${roomCounter}">Room Size (sq ft or sqm)</label>
                        <input type="text" class="form-control" id="room_size_${roomCounter}" name="room[${roomCounter}][size]" placeholder="Enter room size">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="occupancy_limit_${roomCounter}">Occupancy Limit</label>
                        <input type="number" class="form-control" id="occupancy_limit_${roomCounter}" name="room[${roomCounter}][occupancy]" placeholder="Enter occupancy limit">
                    </div>
                    <div class="mb-4">
                        <label class="form-label">Extra Person Allowed</label>
                        <div class="space-x-2">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_yes_${roomCounter}" name="room[${roomCounter}][extra_person]" value="yes">
                                <label class="form-check-label" for="extra_person_yes_${roomCounter}">Yes</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_no_${roomCounter}" name="room[${roomCounter}][extra_person]" value="no" checked>
                                <label class="form-check-label" for="extra_person_no_${roomCounter}">No</label>
                            </div>
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="extra_charges_${roomCounter}">Extra Charges Per Person</label>
                        <input type="number" class="form-control" id="extra_charges_${roomCounter}" name="room[${roomCounter}][extra_charges]" placeholder="Enter extra charges (optional)">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Pricing</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="price_per_night_${roomCounter}">Price per Night</label>
                        <input type="number" class="form-control" id="price_per_night_${roomCounter}" name="room[${roomCounter}][price]" placeholder="Enter price per night">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="discount_${roomCounter}">Discount / Offer %<small>(optional)</small></label>
                        <input type="number" class="form-control" id="discount_${roomCounter}" name="room[${roomCounter}][discount]" placeholder="Enter discount percentage">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="cleaning_fee_${roomCounter}">Cleaning Fee<small>(optional)</small></label>
                        <input type="number" class="form-control" id="cleaning_fee_${roomCounter}" name="room[${roomCounter}][cleaning_fee]" placeholder="Enter cleaning fee">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Amenities</label>
                        <div class="space-y-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="attached_bathroom_${roomCounter}" name="room[${roomCounter}][amenities][]" value="attached_bathroom">
                                <label class="form-check-label" for="attached_bathroom_${roomCounter}">Attached Bathroom</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="ac_${roomCounter}" name="room[${roomCounter}][amenities][]" value="ac">
                                <label class="form-check-label" for="ac_${roomCounter}">Air Conditioner</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="heater_${roomCounter}" name="room[${roomCounter}][amenities][]" value="heater">
                                <label class="form-check-label" for="heater_${roomCounter}">Heater</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="tv_${roomCounter}" name="room[${roomCounter}][amenities][]" value="tv">
                                <label class="form-check-label" for="tv_${roomCounter}">TV</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="geyser_${roomCounter}" name="room[${roomCounter}][amenities][]" value="geyser">
                                <label class="form-check-label" for="geyser_${roomCounter}">Geyser</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="kitchen_access_room_${roomCounter}" name="room[${roomCounter}][amenities][]" value="kitchen_access">
                                <label class="form-check-label" for="kitchen_access_room_${roomCounter}">Kitchen Access</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="towels_${roomCounter}" name="room[${roomCounter}][amenities][]" value="towels">
                                <label class="form-check-label" for="towels_${roomCounter}">Towels/Toiletries</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="balcony_${roomCounter}" name="room[${roomCounter}][amenities][]" value="balcony">
                                <label class="form-check-label" for="balcony_${roomCounter}">Private Balcony / Garden View</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="wardrobe_${roomCounter}" name="room[${roomCounter}][amenities][]" value="wardrobe">
                                <label class="form-check-label" for="wardrobe_${roomCounter}">Wardrobe</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="desk_${roomCounter}" name="room[${roomCounter}][amenities][]" value="desk">
                                <label class="form-check-label" for="desk_${roomCounter}">Desk & Chair</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="fridge_${roomCounter}" name="room[${roomCounter}][amenities][]" value="fridge">
                                <label class="form-check-label" for="fridge_${roomCounter}">Mini Fridge</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="room_service_${roomCounter}" name="room[${roomCounter}][amenities][]" value="room_service">
                                <label class="form-check-label" for="room_service_${roomCounter}">Room Service</label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Room Images</label>
                        <input class="form-control mb-2" type="file" name="room_images[${roomCounter}][]" multiple>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="public_private_${roomCounter}" name="room[${roomCounter}][public_private]" value="private">
                            <label class="form-check-label" for="public_private_${roomCounter}">Private</label>
                        </div>
                    </div>
                </div>
            `;
            roomDetailsContainer.appendChild(newRoomBlock);
            roomCounter++;
        });
    });
</script>
<?php
include('./resources/footer.php');

?>