<?php
session_start();
if(isset($_SESSION['name']))
{
    echo "Login successful";
    header('location:index.php');
}
?>
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">

    <title>Dashmix - Bootstrap 5 Admin Template &amp; UI Framework</title>

    <meta name="description" content="Dashmix - Bootstrap 5 Admin Template &amp; UI Framework created by pixelcave and published on Themeforest">
    <meta name="author" content="pixelcave">
    <meta name="robots" content="noindex, nofollow">

    <!-- Open Graph Meta -->
    <meta property="og:title" content="Dashmix - Bootstrap 5 Admin Template &amp; UI Framework">
    <meta property="og:site_name" content="Dashmix">
    <meta property="og:description" content="Dashmix - Bootstrap 5 Admin Template &amp; UI Framework created by pixelcave and published on Themeforest">
    <meta property="og:type" content="website">
    <meta property="og:url" content="">
    <meta property="og:image" content="">

    <!-- Icons -->
    <!-- The following icons can be replaced with your own, they are used by desktop and mobile browsers -->
    <link rel="shortcut icon" href="assets/media/favicons/favicon.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/media/favicons/favicon-192x192.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/media/favicons/apple-touch-icon-180x180.png">
    <!-- END Icons -->

    <!-- Stylesheets -->
    <!-- Dashmix framework -->
    <link rel="stylesheet" id="css-main" href="assets/css/dashmix.min.css">
  </head>
  <body>
    <!-- Page Container -->
    <div id="page-container">

      <!-- Main Container -->
      <main id="main-container">
        <!-- Page Content -->
        <!-- jQuery Vide for video backgrounds, for more examples you can check out https://github.com/VodkaBears/Vide -->
        <div class="bg-video" data-vide-bg="assets/media/videos/city_night" data-vide-options="posterType: jpg">
          <div class="row g-0 bg-xplay-op">
            <!-- Meta Info Section -->
            <div class="hero-static col-md-6 d-none d-md-flex align-items-md-center justify-content-md-center text-md-center">
              <div class="p-3">
                <p class="display-4 fw-bold text-white mb-0">
                  Visualise your idea..
                </p>
                <p class="fs-1 fw-semibold text-white-75 mb-0">
                  ..and build it!
                </p>
              </div>
            </div>
            <!-- END Meta Info Section -->

            <!-- Main Section -->
            <div class="hero-static col-md-6 d-flex align-items-center bg-body-extra-light">
              <div class="p-3 w-100">
                <!-- Header -->
                <div class="text-center">
                  <a class="link-fx fw-bold fs-1" href="index.html">
                    <span class="text-dark">Dash</span><span class="text-primary">mix</span>
                  </a>
                  <p class="text-uppercase fw-bold fs-sm text-muted">Account Lock Screen</p>
                </div>
                <!-- END Header -->

                <!-- User -->
                <div class="py-4 text-center">
                  <img class="img-avatar img-avatar96" src="assets/media/avatars/avatar10.jpg" alt="">
                  <p class="mt-3 mb-0 fw-semibold fs-lg">
                    John Doe
                  </p>
                  <p class="mb-0 text-muted">
                    Web Developer
                  </p>
                </div>
                <!-- END User -->

                <!-- Unlock Form -->
                <!-- jQuery Validation (.js-validation-lock class is initialized in js/pages/op_auth_lock.min.js which was auto compiled from _js/pages/op_auth_lock.js) -->
                <!-- For more info and examples you can check out https://github.com/jzaefferer/jquery-validation -->
                <div class="row g-0 justify-content-center">
                  <div class="col-sm-8 col-xl-6">
                    <form class="js-validation-lock" action="" method="POST">
                      <div class="py-3 mb-2">
                        <input type="text" class="form-control form-control-lg form-control-alt" id="email" name="email" placeholder="Enter Email.." required>
                      </div>
                      <div class="py-3 mb-4">
                        <input type="password" class="form-control form-control-lg form-control-alt" id="password" name="password" placeholder="Enter Password.." required>
                      </div>
                      <div class="text-center mb-4">
                        <button type="submit" class="btn w-100 btn-lg btn-hero btn-primary" value="login_submit" name="login_submit">
                          <i class="fa fa-fw fa-lock-open opacity-50 me-1"></i> Unlock
                        </button>
                        <p class="mt-3 mb-0 d-lg-flex justify-content-lg-between">
                          <a class="btn btn-sm btn-alt-secondary d-block d-lg-inline-block mb-1" href="op_auth_reminder.html">
                            <i class="fa fa-exclamation-triangle opacity-50 me-1"></i> Forgot password
                          </a>
                          <a class="btn btn-sm btn-alt-secondary d-block d-lg-inline-block mb-1" href="op_auth_signin.html">
                            <i class="fa fa-sign-out-alt opacity-50 me-1"></i> Sign Out
                          </a>
                        </p>
                      </div>
                    </form>
                  </div>
                </div>
                <!-- END Unlock Form -->
              </div>
            </div>
            <!-- END Main Section -->
          </div>
        </div>
        <!-- END Page Content -->
      </main>
      <!-- END Main Container -->
    </div>
    <!-- END Page Container -->

    <!--
      Dashmix JS

      Core libraries and functionality
      webpack is putting everything together at assets/_js/main/app.js
    -->
    <script src="assets/js/dashmix.app.min.js"></script>

    <!-- jQuery (required for jQuery Validation plugin) -->
    <script src="assets/js/lib/jquery.min.js"></script>

    <!-- Page JS Plugins -->
    <script src="assets/js/plugins/vide/jquery.vide.min.js"></script>
    <script src="assets/js/plugins/jquery-validation/jquery.validate.min.js"></script>

    <!-- Page JS Code -->
    <script src="assets/js/pages/op_auth_lock.min.js"></script>
  </body>
</html>
