<?php
include('./config/dbcon.php');
include('./resources/header.php');
$query=mysqli_query($conn,"SELECT * FROM Hotel_Add");

?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Add Rooms</h3>
            </div>
            <div class="block-content">
                <form class="mb-4" action="insert_Action.php" method="POST" enctype="multipart/form-data" onsubmit="return validateValues()">
                    <h2 class="content-heading">Basic Information</h2>

                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="status">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                    
                                </select>
                            </div>
                          <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="property_type">Property Name</label>
                                <select class="form-select" id="property_name" name="property_name">
                                    <?php
                                 // Loop through each spot and create an option
                                        while ($row = mysqli_fetch_assoc($query)) {
                                             echo '<option value="' . $row['hotel_id'] . '">' . htmlspecialchars($row['name']) . '</option>';
                                        }
                                   ?>
                                </select>
                              <span id="property_choose_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                                    
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="property_type">Enter Room Name.</label>
                                <input type="text" class="form-control" id="room_name" name="room_name" placeholder="Enter Room Name..">
                                 <span id="room_name_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="rDescription">Room Description</label>
                                    <textarea class="form-control" id="room_descr" name="room_descr" placeholder="Enter Room Description.."></textarea>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="fDescription">Room Size(in Sq.ft.)</label>
                                     <input type="number" class="form-control" id="room_size" name="room_size" placeholder="Enter Room Size..">
                                      <span id="room_size_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="occupancy">Occupancy</label>
                                <input type="number" class="form-control" id="occupancy" name="occupancy" placeholder="Enter Occupancy..">
                                 <span id="room_occupancy_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="email">Extra_Person</label>
                                <input type="number" class="form-control" id="extra_person" name="extra_person" placeholder="Enter Extra Person..">
                                 <span id="extra_person_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Prices</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                             <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="extra_charges">Extra Charges</label>
                                <input type="number" class="form-control" id="extra_charges" name="extra_charges" placeholder="Enter Extra Charges..">
                                <span id="extra_charges_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="price">Price per Night.</label>
                                <input type="number" class="form-control" id="price" name="price" placeholder="Enter Price per Night..">
                                <span id="price_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="name">Discount</label>
                                <input type="number" class="form-control" id="discount" name="discount" placeholder="Enter Discount..">
                                <span id="discount_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="name">Cleaning Fee</label>
                                <input type="number" class="form-control" id="cleaning_fee" name="cleaning_fee" placeholder="Enter Cleaning fee..">
                                <span id="cleaning_fee_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            
                        </div>
                    </div>
                    <h2 class="content-heading">Room Features/Facilities</h2>
                    <div class="row push mx-4">
                        <div class="col-12 overflow-hidden">
                            <div class="mb-4">
                                <div class="space-y-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="attached_bathroom" id="attached_bathroom" name="attached_bathroom">
                                        <label class="form-check-label" for="attached_bathroom">Attached Bathroom</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="ac" id="ac" name="ac">
                                        <label class="form-check-label" for="ac">Air Conditioner</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="heater" id="heater" name="heater">
                                        <label class="form-check-label" for="heater">Heater</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="	tv" id="tv" name="tv">
                                        <label class="form-check-label" for="tv">Television</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="geyser" id="geyser" name="geyser">
                                        <label class="form-check-label" for="geyser">Geyser</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="kitchen" id="kitchen" name="kitchen">
                                        <label class="form-check-label" for="kitchen">Kitchen</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="towels" id="towels" name="towels">
                                        <label class="form-check-label" for="towels">Towels</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="garden_view" id="garden_view" name="garden_view">
                                        <label class="form-check-label" for="garden_view">Garden View</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="wardrobe" id="wardrobe" name="wardrobe">
                                        <label class="form-check-label" for="wardrobe">Wardrobe</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="deskChair" id="deskChair" name="deskChair">
                                        <label class="form-check-label" for="deskChair">DeskChair</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="mini_Fridge" id="mini_Fridge" name="mini_Fridge">
                                        <label class="form-check-label" for="mini_Fridge">Mini Fridge</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="room_service" id="room_service" name="room_service">
                                        <label class="form-check-label" for="room_service">Room_Service</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="publicOrPrivate" id="publicOrPrivate" name="publicOrPrivate">
                                        <label class="form-check-label" for="publicOrPrivate">Public or Private</label>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Images</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-12">
                                <label class="form-label" for="cover_image">Room Image</label>
                                <input class="form-control" type="file" id="room_image" name="room_image">
                                <span id="room_image_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                        </div>
                    </div>
                    <div class="mb-4 col-lg-12 col-sm-12 p-5">
                        <button type="submit" name="room_submit" value="room_submit" class="btn btn-primary w-100">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let roomCounter = 2;
        const roomDetailsContainer = document.getElementById('room_details_container');
        const addRoomButton = document.getElementById('add_room_button');

        addRoomButton.addEventListener('click', function() {
            const newRoomBlock = document.createElement('div');
            newRoomBlock.classList.add('block', 'block-rounded', 'mb-4');
            newRoomBlock.innerHTML = `
                <div class="block-header block-header-default">
                    <h3 class="block-title">Room ${roomCounter}</h3>
                </div>
                <div class="block-content">
                    <div class="mb-4">
                        <label class="form-label">Basic Info.</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_name_${roomCounter}">Room Name</label>
                        <input type="text" class="form-control" id="room_name_${roomCounter}" name="room[${roomCounter}][name]" placeholder="Enter room name">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_description_${roomCounter}">Room Description</label>
                        <input type="text" class="form-control" id="room_description_${roomCounter}" name="room[${roomCounter}][description]" placeholder="Enter room description">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_size_${roomCounter}">Room Size (sq ft or sqm)</label>
                        <input type="text" class="form-control" id="room_size_${roomCounter}" name="room[${roomCounter}][size]" placeholder="Enter room size">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="occupancy_limit_${roomCounter}">Occupancy Limit</label>
                        <input type="number" class="form-control" id="occupancy_limit_${roomCounter}" name="room[${roomCounter}][occupancy]" placeholder="Enter occupancy limit">
                    </div>
                    <div class="mb-4">
                        <label class="form-label">Extra Person Allowed</label>
                        <div class="space-x-2">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_yes_${roomCounter}" name="room[${roomCounter}][extra_person]" value="yes">
                                <label class="form-check-label" for="extra_person_yes_${roomCounter}">Yes</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_no_${roomCounter}" name="room[${roomCounter}][extra_person]" value="no" checked>
                                <label class="form-check-label" for="extra_person_no_${roomCounter}">No</label>
                            </div>
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="extra_charges_${roomCounter}">Extra Charges Per Person</label>
                        <input type="number" class="form-control" id="extra_charges_${roomCounter}" name="room[${roomCounter}][extra_charges]" placeholder="Enter extra charges (optional)">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Pricing</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="price_per_night_${roomCounter}">Price per Night</label>
                        <input type="number" class="form-control" id="price_per_night_${roomCounter}" name="room[${roomCounter}][price]" placeholder="Enter price per night">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="discount_${roomCounter}">Discount / Offer %<small>(optional)</small></label>
                        <input type="number" class="form-control" id="discount_${roomCounter}" name="room[${roomCounter}][discount]" placeholder="Enter discount percentage">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="cleaning_fee_${roomCounter}">Cleaning Fee<small>(optional)</small></label>
                        <input type="number" class="form-control" id="cleaning_fee_${roomCounter}" name="room[${roomCounter}][cleaning_fee]" placeholder="Enter cleaning fee">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Amenities</label>
                        <div class="space-y-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="attached_bathroom_${roomCounter}" name="room[${roomCounter}][amenities][]" value="attached_bathroom">
                                <label class="form-check-label" for="attached_bathroom_${roomCounter}">Attached Bathroom</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="ac_${roomCounter}" name="room[${roomCounter}][amenities][]" value="ac">
                                <label class="form-check-label" for="ac_${roomCounter}">Air Conditioner</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="heater_${roomCounter}" name="room[${roomCounter}][amenities][]" value="heater">
                                <label class="form-check-label" for="heater_${roomCounter}">Heater</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="tv_${roomCounter}" name="room[${roomCounter}][amenities][]" value="tv">
                                <label class="form-check-label" for="tv_${roomCounter}">TV</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="geyser_${roomCounter}" name="room[${roomCounter}][amenities][]" value="geyser">
                                <label class="form-check-label" for="geyser_${roomCounter}">Geyser</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="kitchen_access_room_${roomCounter}" name="room[${roomCounter}][amenities][]" value="kitchen_access">
                                <label class="form-check-label" for="kitchen_access_room_${roomCounter}">Kitchen Access</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="towels_${roomCounter}" name="room[${roomCounter}][amenities][]" value="towels">
                                <label class="form-check-label" for="towels_${roomCounter}">Towels/Toiletries</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="balcony_${roomCounter}" name="room[${roomCounter}][amenities][]" value="balcony">
                                <label class="form-check-label" for="balcony_${roomCounter}">Private Balcony / Garden View</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="wardrobe_${roomCounter}" name="room[${roomCounter}][amenities][]" value="wardrobe">
                                <label class="form-check-label" for="wardrobe_${roomCounter}">Wardrobe</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="desk_${roomCounter}" name="room[${roomCounter}][amenities][]" value="desk">
                                <label class="form-check-label" for="desk_${roomCounter}">Desk & Chair</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="fridge_${roomCounter}" name="room[${roomCounter}][amenities][]" value="fridge">
                                <label class="form-check-label" for="fridge_${roomCounter}">Mini Fridge</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="room_service_${roomCounter}" name="room[${roomCounter}][amenities][]" value="room_service">
                                <label class="form-check-label" for="room_service_${roomCounter}">Room Service</label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Room Images</label>
                        <input class="form-control mb-2" type="file" name="room_images[${roomCounter}][]" multiple>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="public_private_${roomCounter}" name="room[${roomCounter}][public_private]" value="private">
                            <label class="form-check-label" for="public_private_${roomCounter}">Private</label>
                        </div>
                    </div>
                </div>
            `;
            roomDetailsContainer.appendChild(newRoomBlock);
            roomCounter++;
        });
    });
    
    function validateValues() {
    // Reset all error messages
    var errorMessages = document.querySelectorAll('.error-message');
    errorMessages.forEach(function(msg) {
        msg.textContent = '';
    });

    // Validate car image size
    var cover_image = document.getElementById('room_image');
    var imageError = document.getElementById('room_image_error');
    if (cover_image.files.length > 0) {
        var fileSize = cover_image.files[0].size / 1024 / 1024; // Convert size to MB
        if (fileSize > 2) {
            imageError.textContent = '*Image size must be less than or equal to 2MB.';
            return false;
        } else {
            imageError.textContent = '';
        }
    } else {
        imageError.textContent = '*Please upload a room Image.';
        return false;
    }
    //Validate Property name
    var property_name = document.getElementById('property_name').value;
    var property_choose_error = document.getElementById('property_choose_error');
    if (property_name === '') {
        property_choose_error.textContent = '*Please select a Property.';
        return false;
    } else {
        property_choose_error.textContent = '';
    }

    //Validate room name
    var room_name = document.getElementById('room_name').value;
    var room_name_error = document.getElementById('room_name_error');
    if (room_name === '') {
        room_name_error.textContent = '*Please enter a room name .';
        return false;
    } else {
        room_name_error.textContent = '';
    }
    //Validate room size
    var room_size = document.getElementById('room_size').value.trim();
    var room_size_error = document.getElementById('room_size_error');
    if (room_size === '') {
        room_size_error.textContent = '*Please enter room size.';
        return false;
    } else {
        room_size_error.textContent = '';
    }
    
    // Validate room occupancy
    var occupancy = document.getElementById('occupancy').value.trim();
    var room_occupancy_error = document.getElementById('room_occupancy_error');
    if (occupancy === '') {
        room_occupancy_error.textContent = '*Room occupancy is required.';
        return false;
    } else {
        room_occupancy_error.textContent = '';
    }
      
    // Validate extra person
    var extra_person= document.getElementById('extra_person').value.trim();
    var extra_person_error = document.getElementById('extra_person_error');
    if (extra_person === '') {
        extra_person_error.textContent = '*Extra person allowed or not .';
        return false;
    } else {
       extra_person_error.textContent = '';
    }
// Validate prices
    var price= document.getElementById('price').value.trim();
    var price_error = document.getElementById('price_error');
    if (price === '') {
        price_error.textContent = '*Price per night is required .';
        return false;
    } else {
       price_error.textContent = '';
    }
    
    // Validate extra charges
    var extra_charges= document.getElementById('extra_charges').value.trim();
    var extra_charges_error = document.getElementById('extra_charges_error');
    if (extra_charges === '') {
        extra_charges_error.textContent = '*Extra charges needed or not .';
        return false;
    } else {
       extra_charges_error.textContent = '';
    }
    
    // Validate discount
    var discount= document.getElementById('discount').value.trim();
    var discount_error = document.getElementById('discount_error');
    if (discount === '') {
        discount_error.textContent = '*Enter Discount .';
        return false;
    } else {
       discount_error.textContent = '';
    }
    
// Validate cleaning fee
    var cleaning_fee= document.getElementById('cleaning_fee').value.trim();
    var cleaning_fee_error = document.getElementById('cleaning_fee_error');
    if (cleaning_fee === '') {
        cleaning_fee_error.textContent = '*Enter cleaning fee .';
        return false;
    } else {
       cleaning_fee_error.textContent = '';
    }
    
    // If all validations pass, submit the form
    return true;
}
</script>
<?php
include('./resources/footer.php');
?>