<?php
include('./resources/header.php');
include('config/dbcon.php');
$choose_spot=mysqli_query($conn,"SELECT * FROM spots");

?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Add Cars</h3>
            </div>
            <div class="block-content">
                <form class="mb-4 " style="ml-4" method="POST" action="insert_Action_Car.php" onsubmit="return validateValues()"
                    enctype="multipart/form-data">
                    <h2 class="content-heading">Basic Information</h2>
                    <div class="row push ms-2">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="property_type">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="car_img" >Car Image</label>
                                <input type="file" class="form-control" id="car_img" name="car_img">
                                 <span id="imageError" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                             <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="price">Car Name</label>
                                <input type="text" class="form-control" id="car_name" name="car_name"
                                    placeholder="Enter Car Name..">
                                    <span id="carNameError" class="error-message text-danger"  style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="price">Price</label>
                                <input type="number" class="form-control" id="price" name="price"
                                    placeholder="Enter price..">
                                    <span id="priceError" class="error-message text-danger"  style="font-size: 10px;"></span>
                            </div>
                            


                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="car_description">Car Description.</label>
                                <textarea class="form-control" id="car_description" name="car_description" rows="4"
                                    placeholder="Enter Description.."></textarea>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="sideScene">Side Scene</label>
                                <textarea class="form-control" id="sideScene" name="sideScene" rows="4"
                                    placeholder="Enter Side scene description.."></textarea>
                            </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="spotA">Spot A</label>
                                <select class="form-select" id="spotA" name="spotA">
                                    <?php
                                 // Loop through each spot and create an option
                                        while ($row = mysqli_fetch_assoc($choose_spot)) {
                                echo '<option value="' . $row['spotId'] . '">' . htmlspecialchars($row['spot']) . '</option>';
                                   }
                                   ?>
                                </select>
                                <span id="spotAError" class="error-message text-danger"  style="font-size: 10px;"></span>
                            </div>
                               <?php
                             // Move the result pointer back to the beginning
                            mysqli_data_seek($choose_spot, 0);
                                    ?>

                                <div class="mb-4 col-lg-6 col-sm-12">
                                    <label class="form-label" for="spotB">Spot B</label>
                                   <select class="form-select" id="spotB" name="spotB">
                                <?php
                                 while ($spot = mysqli_fetch_assoc($choose_spot)) {
                                    echo '<option value="' . $spot['spotId'] . '">' . htmlspecialchars($spot['spot']) . '</option>';
                                  }
                                   ?>
                             </select>
                             <span id="spotBError" class="error-message text-danger"  style="font-size: 10px;"></span>
                               </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="seatLimit">Max Seat Limit</label>
                                <input type="number" class="form-control" id="seatLimit" name="seatLimit"
                                    placeholder="Enter maximum seat limit..">
                                     <span id="seatLimitError" class="error-message text-danger"  style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="scenePrice">Side Scene Price</label>
                                <input type="number" class="form-control" id="scenePrice" name="scenePrice"
                                    placeholder="Enter Side scene price..">
                                     <span id="scenePriceError" class="error-message text-danger"  style="font-size: 10px;"></span>
                            </div>
                            
                        </div>
                    </div>
                    <div style="ms-4 mb-4 col-lg-4 col-sm-12 p-5 ">
                        <center><button type="submit" name="submit" value="submit" class="btn btn-primary w-100">Save</button>
                        </center>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<?php
include('./resources/footer.php');
?>
<script>
function validateValues() {
    // Reset all error messages
    var errorMessages = document.querySelectorAll('.error-message');
    errorMessages.forEach(function(msg) {
        msg.textContent = '';
    });

    // Validate car image size
    var carImage = document.getElementById('car_img');
    var imageError = document.getElementById('imageError');
    if (carImage.files.length > 0) {
        var fileSize = carImage.files[0].size / 1024 / 1024; // Convert size to MB
        if (fileSize > 2) {
            imageError.textContent = '*Image size must be less than or equal to 2MB.';
            return false;
        } else {
            imageError.textContent = '';
        }
    } else {
        imageError.textContent = '*Please upload a car image.';
        return false;
    }

    // Validate car name
    var carName = document.getElementById('car_name').value.trim();
    var carNameError = document.getElementById('carNameError');
    if (carName === '') {
        carNameError.textContent = '*Car name is required.';
        return false;
    } else {
        carNameError.textContent = '';
    }

    // Validate car price
    var price = document.getElementById('price').value.trim();
    var priceError = document.getElementById('priceError');
    if (price === '') {
        priceError.textContent = '*Car price is required.';
        return false;
    } else {
        priceError.textContent = '';
    }

    // Validate state selection
    var state = document.getElementById('state').value;
    var stateError = document.getElementById('stateError');
    if (state === '') {
        stateError.textContent = '*Please choose a state.';
        return false;
    } else {
        stateError.textContent = '';
    }

    // Validate Spot A selection
    var spotA = document.getElementById('spotA').value;
    var spotAError = document.getElementById('spotAError');
    if (spotA === '') {
        spotAError.textContent = '*Please select a Spot A.';
        return false;
    } else {
        spotAError.textContent = '';
    }

    // Validate Spot B selection
    var spotB = document.getElementById('spotB').value;
    var spotBError = document.getElementById('spotBError');
    if (spotB === '') {
        spotBError.textContent = '*Please select a Spot B.';
        return false;
    } else {
        spotBError.textContent = '';
    }

    // Validate max seat limit
    var seatLimit = document.getElementById('seatLimit').value.trim();
    var seatLimitError = document.getElementById('seatLimitError');
    if (seatLimit === '') {
        seatLimitError.textContent = '*Max seat limit is required.';
        return false;
    } else {
        seatLimitError.textContent = '';
    }

    // Validate side scene price
    var scenePrice = document.getElementById('scenePrice').value.trim();
    var scenePriceError = document.getElementById('scenePriceError');
    if (scenePrice === '') {
        scenePriceError.textContent = '*Side scene price is required.';
        return false;
    } else {
        scenePriceError.textContent = '';
    }

    // If all validations pass, submit the form
    return true;
}
</script>
