<?php
include('resources/header.php');
session_start();



if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $_SESSION['car_booking'] = $_POST;
    $Cid = $_POST['carId'];
    // echo '<pre>';
    // print_r($_SESSION['car_booking']);
    // echo '</pre>';
    $carId = $_POST['carId'];
    $price = $_POST['price'];
    $scenePrice = $_POST['scenePrice'];
    $fullName = $_POST['full_name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $starting_date = $_POST['starting_date'];
    $formatted_start_date = date('Y-m-d', strtotime(str_replace('-', '/', $starting_date)));
    $ending_date = $_POST['ending_date'];
    $formatted_end_date = date('Y-m-d', strtotime(str_replace('-', '/', $ending_date)));
    $spotA = $_POST['spotA'];
    $spotB = $_POST['spotB'];
    $message_car = $_POST['message'];
    $daily_price = $_POST['total_amount'];
    $visit_site_scene=$_POST['visit-site-scene'];
    $site_scene=$_POST['site_scene_details'];
    
    $totalAmount = $daily_price;
    
    $car_sql=mysqli_query($conn,"SELECT add_car_details.*, spotA_table.spot AS spotA_name, spotB_table.spot AS spotB_name FROM add_car_details LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId WHERE carId='$carId'");
    $car_fetch=mysqli_fetch_assoc($car_sql);
    $carImgPath = 'admin/dashboard/' . $car_fetch['car_img'];
    $fallbackImg = 'assets/images/resort.jpg';
    if (empty($car_fetch['car_img']) || !file_exists($carImgPath)) {
        $carImgPath = $fallbackImg;
    }
}

$car_fetch_query = mysqli_query($conn, "SELECT * FROM add_car_details WHERE carId = $Cid");
$car = mysqli_fetch_assoc($car_fetch_query);

$carspotA = htmlspecialchars($car['spotA']);
$carspotB = htmlspecialchars($car['spotB']);

$whereClauses = ["Hotel_Add.status = '1'"];
$whereClauses[] = "(Hotel_Add.choose = '$carspotA' OR Hotel_Add.choose = '$carspotB')";
$whereSQL = implode(" AND ", $whereClauses);

$spot_fetch = mysqli_query($conn, "
    SELECT Hotel_Add.*, spotA_table.spot AS spotA_name, spotB_table.spot AS spotB_name 
    FROM Hotel_Add 
    LEFT JOIN spots AS spotA_table ON Hotel_Add.choose = spotA_table.spotId 
    LEFT JOIN spots AS spotB_table ON Hotel_Add.choose = spotB_table.spotId 
    WHERE $whereSQL
");
?>
<style>
    .form-control-modern {
  border-radius: 10px;
  border: 1px solid #ced4da;
  padding: 10px 14px;
  font-size: 15px;
  transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #eb5744 !important;
    box-shadow: 0 0 0 0.2rem rgb(253 13 113 / 15%) !important;
}
.package-card-alpha .package-card-body .p-card-bottom .book-btn button {
    display: inline-block;
    font-weight: 600;
    font-size: 15px;
    text-transform: uppercase;
    color: #ff4838;
    /*background: #ffffff;*/
    border: 1px solid #ff4838;
    box-sizing: border-box;
    border-radius: 5px;
    padding: 8px 16px;
    transition: all 0.3s;
}

.btn-skip-modern {
    background: linear-gradient(135deg, #ff4838, #ff7c5c);
    color: #fff;
    padding: 12px 28px;
    font-size: 16px;
    font-weight: 600;
    border: none;
    border-radius: 8px;
    box-shadow: 0 4px 10px rgba(255, 72, 56, 0.3);
    transition: all 0.3s ease-in-out;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.btn-skip-modern:hover {
    background: linear-gradient(135deg, #ff7c5c, #ff4838);
    transform: translateY(-2px);
    box-shadow: 0 6px 14px rgba(255, 72, 56, 0.4);
}
    .booking-action-btn {
        transition: all 0.3s ease;
        font-weight: 600;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        padding: 12px 20px;
    }

    .booking-action-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
    }

    .booking-action-btn:active {
        transform: scale(0.98);
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
    }

    .btn-book-car-only {
        background: linear-gradient(135deg, #ff4838, #ff7c5c);
        color: #fff;
        border: none;
    }

    .btn-book-car-only:hover {
        background: linear-gradient(135deg, #ff7c5c, #ff4838);
        color: #fff;
        /*border: 2px solid #ff7c5c;*/
    }

    .btn-book-car-property {
        background: linear-gradient(135deg, #007bff, #6610f2);
        color: white;
        border: none;
    }

    .btn-book-car-property:hover {
        background: linear-gradient(135deg, #6610f2, #007bff);
    }

    .fade-in-up {
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<!-- ===============  breadcrumb area start =============== -->

<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Property Suggestions</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item"><a href="property_details.php?id=<?php echo $car['carId']; ?>">
                    <?php echo htmlspecialchars($car['car_name']); ?>
                </a></li>
                <li class="breadcrumb-item active">Property Suggestions</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->
<div class="package-details-wrapper pt-76">
    <div class="container">
        <div class="row">
            <!-- LEFT COLUMN -->
            <div class="col-lg-12 mb-4">
                <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-20">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Booking Details</h4>
                             <h3 class="widget-lavel"><span>Total Amount:</span> ₹<?php echo $totalAmount?></h3>
                        </div>

                        <div class="widget-body mb-4 mb-sm-4">
                            <form action="checkOut.php" method="post">
                                <div class="booking-form-wrapper row">
                                    <?php
                                    if (!empty($_POST['carId'])) {
                                    ?>
                                    <!-- Car Info -->
                                    <div class="mb-4 col-6 p-3 rounded bg-light border">
                                        <h6 class="text-dark mb-2"><span class="badge bg-warning text-dark" style="font-size: 15px;"> Car - ₹<?php echo $car_fetch['price']; ?></span></h6>
                                        <p class="mb-1"><strong>Car:</strong> <?php echo $car_fetch['car_name']; ?></p>
                                        <p class="mb-1"><strong>From:</strong> <?php echo $spotA; ?></p>
                                        <p class="mb-1"><strong>To:</strong> <?php echo $spotB; ?></p>
                                        <p class="mb-1"><strong>Date:</strong> <?php echo $formatted_start_date; ?></p>
                                        <p class="mb-1"><strong>Max Seats:</strong> <?php echo $car_fetch['maxSeat']; ?></p>
                                        <?php
                                        if($visit_site_scene=='on'){
                                        ?>
                                        <p class="mb-1"><span class="badge bg-warning text-dark" style="font-size: 15px;">Sightseeing: - ₹<?php echo $car_fetch['scenePrice']; ?></span></p>
                                        <p class="mb-0"><strong>Sightseeing Places:</strong> <?php echo $site_scene; ?></p>
                                        <?php } ?>
                                    </div>
                                    <div class="mb-4 col-6 p-3 rounded bg-light border">
                                        <img src="<?= $carImgPath?>" style="width: inherit;">
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <!-- Total -->
                                    <hr class="my-3">
                                    <!-- Action Buttons -->
                                    <div class="d-flex justify-content-between gap-3 mt-4 fade-in-up">
                                        <!--<form  class="text-center mb-3">-->
                                            <?php if (isset($_SESSION['car_booking'])): ?>
                                                <input type="hidden" name="car_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['car_booking'])); ?>">
                                            <?php endif; ?>
                                            <button type="submit" class="booking-action-btn btn-book-car-only w-50">
                                                Skip & Book Car Only
                                            </button>
                                
                                        <!--</form>-->
                                        <button type="button" onclick="scrollToPropertySection()" name="choose_property" class="booking-action-btn btn-book-car-property w-50">
                                            Book Car with Property
                                        </button>
                                    </div>



                                </div>
                            </form>
                        </div>
                    </aside>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="package-wrapper pt-3"  id="property-content">
    <div class="container">
        <form id="property-search-form" class="mb-5">
            <div class="bg-light p-4 rounded shadow-sm">
                <div class="d-flex flex-wrap align-items-end gap-3">
                    <div class="flex-grow-1">
                        <select class="form-select form-control-modern" name="type" id="type">
                            <option value="">Choose Property Type</option>
                            <option value="hotel">Hotel</option>
                            <option value="resort">Resort</option>
                            <option value="homestay">Homestay</option>
                        </select>
                    </div>
                    <div class="flex-grow-1">
                        <input type="text" class="form-control form-control-modern" name="property_name" placeholder="Property Name">
                    </div>
                    <input type="hidden" value="<?= $Cid?>" name="Cid">
                    <div>
                        <button type="submit" class="btn btn-danger rounded-pill px-4">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </form>

        <div class="row">
            <div id="property-results" class="row">
                <!-- AJAX results will be injected here -->
            </div>

            <?php while ($property_display = mysqli_fetch_array($spot_fetch)) { 
                $propertyImgPath = 'admin/dashboard/' . $property_display['cover_img'];
                $fallbackImg = 'admin/dashboard/upload/resort.jpg';
                if (empty($property_display['cover_img']) || !file_exists($propertyImgPath)) {
                    $propertyImgPath = $fallbackImg;
                }
            ?>
                <div class="col-lg-4 mb-4">
                    <div class="package-card-alpha">
                        <div class="package-thumb">
                            <a href="<?php echo $propertyImgPath; ?>" data-fancybox="gallery" data-caption="Caption Here" class="gallary-item-overlay">
                                <img src="<?php echo $propertyImgPath; ?>" alt="Gallery Image" style="height: 200px;">
                            </a>
                            
                        </div>

                         <div class="package-card-body">
                            <h3 class="p-card-title"><?php echo $property_display['name'] ?></h3>
                            <h5><?php echo $property_display['spotA_name'] ?></h5>
                            <div class="p-card-bottom">
                                <div class="book-btn">
                                    <button 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#propertyBookingModal" 
                                       
                                        data-hotel-id="<?php echo $property_display['hotel_id']; ?>" 
                                        data-hotel-name="<?php echo htmlspecialchars($property_display['name']); ?>" 
                                    >
                                        Book Now <i class='bx bxs-right-arrow-alt'></i>
                                    </button>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <form action="checkOut.php" method="post" class="text-center mb-3">
            <?php if (isset($_SESSION['car_booking'])): ?>
                <input type="hidden" name="car_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['car_booking'])); ?>">
            <?php endif; ?>
            <button type="submit" class="btn-skip-modern">
                Skip Property Booking <i class="fa-solid fa-arrow-right ms-2"></i>
            </button>

        </form>
    </div>
</div>

<!-- Booking Modal -->
<div class="modal fade" id="propertyBookingModal" tabindex="-1" aria-labelledby="propertyBookingModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
        <div class="col-lg-12">
          <div class="package-sidebar">
            <aside class="package-widget-style-2 widget-form mt-3">
              <div class="widget-title text-center d-flex justify-content-between">
                <h4>Book This Property</h4>
              </div>
              <div class="widget-body mb-4">
                <form action="checkOut.php" method="post">
                    <?php if (isset($_SESSION['car_booking'])): ?>
                        <input type="hidden" name="car_booking_data" value="<?php echo htmlspecialchars(json_encode($_SESSION['car_booking'])); ?>">
                    <?php endif; ?>
                  <div class="booking-form-wrapper">
                    <input type="hidden" name="hotelId" id="modalHotelId">
                    <input type="hidden" name="price" id="modalPrice">
                    <input type="hidden" name="full_name" placeholder="Your Full Name" required value="<?php echo $_POST['full_name'] ?>">
                    <input type="hidden" name="email" placeholder="Your Email" required value="<?php echo $_POST['email'] ?>">
                    <input type="hidden" name="phone" placeholder="Phone" required value="<?php echo $_POST['phone'] ?>">
                    
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="custom-input-group">
                                <i class="bi bi-chevron-down"></i>
                                <select id="truist-adult" name="adults" required>
                                    <option value="" disabled selected>Adult</option>
                                    <?php for ($i = 1; $i <= 20; $i++): ?>
                                        <option value="<?php echo $i; ?>"> <?php echo $i; ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!-- Room Selection -->
                    <div class="custom-input-group">
                        <select id="room-selection" name="room_id" required>
                          <option value="" disabled selected>Select a Room</option>
                        </select>
                    </div>
                    <div class="custom-input-group">
                        <i class="bi bi-chevron-down"></i>
                        <select id="no-of-rooms" name="number_of_rooms" required>
                          <option value="" disabled selected>No. of Rooms</option>
                        </select>
                    </div>
                    
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="custom-input-group">
                                <input placeholder="Check-in" type="date" name="fromDate" id="fromDate" required>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="custom-input-group ">
                                <input placeholder="Check-out" type="date" name="toDate" id="toDate" required>
                            </div>
                        </div>
                    </div>

                    <div class="custom-input-group">
                      <label><strong>Total Amount:</strong></label>
                      <input type="text" name="total_amount" id="totalAmount" readonly style="background: #f1f1f1;">
                      <input type="text" name="total" id="total" hidden>
                    </div>

                    <div class="custom-input-group">
                      <div class="submite-btn">
                        <button type="submit" name="book_hotel_now">Book Now</button>
                      </div>
                    </div>

                  </div>
                </form>
              </div>
            </aside>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<?php include('./resources/footer.php'); ?>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function scrollToPropertySection() {
        const target = document.getElementById('property-content');
        if (target) {
            target.scrollIntoView({ behavior: 'smooth' });
        }
    }
</script>
<script>
  let selectedAdults = 0;

  // Track adult selection
  $(document).on('change', '#truist-adult', function () {
    selectedAdults = parseInt($(this).val()) || 0;
    $('#room-selection').prop('disabled', false); // Enable room selection once adults chosen
  });

  // Handle room selection
  $(document).on('change', '#room-selection', function () {
    const selectedOption = $(this).find('option:selected');
    const occupancy = parseInt(selectedOption.data('occupancy')) || 1;

    // Fallback if adult count is not selected
    if (!selectedAdults) {
      alert('Please select number of adults first.');
      $(this).val('');
      return;
    }

    const minRooms = Math.ceil(selectedAdults / occupancy);
    const maxRooms = 10;

    const $noOfRooms = $('#no-of-rooms');
    $noOfRooms.empty().append('<option value="" disabled selected>No. of Rooms</option>');

    for (let i = minRooms; i <= maxRooms; i++) {
      $noOfRooms.append('<option value="' + i + '">' + i + '</option>');
    }
  });

  // Load room options when modal is shown
  $('#propertyBookingModal').on('show.bs.modal', function (event) {
    const button = $(event.relatedTarget);
    const hotelId = button.data('hotel-id');
    const modal = $(this);

    modal.find('#modalHotelId').val(hotelId);

    $.ajax({
      url: 'get_rooms_by_hotel.php',
      method: 'POST',
      data: { hotel_id: hotelId },
      success: function (response) {
        const rooms = JSON.parse(response);
        const $roomSelection = modal.find('#room-selection');
        $roomSelection.empty().append('<option value="" disabled selected>Select a Room</option>');

        rooms.forEach(function (room) {
          let optionText = `${room.room_name} - ₹${room.price_per_night}/night`;
          if (room.discount > 0) {
            optionText += ` (${room.discount}% off)`;
          }
          $roomSelection.append(
            `<option value="${room.roomId}" data-price="${room.price_per_night}" data-occupancy="${room.occupancy}" data-discount="${room.discount}">${optionText}</option>`
          );
        });

        // Disable room selection until adult count is selected
        $roomSelection.prop('disabled', !selectedAdults);
      },
      error: function () {
        alert('Failed to fetch room details.');
      }
    });
  });
</script>

<script>
//   // Handle modal show event
//   $('#propertyBookingModal').on('show.bs.modal', function (event) {
//     var button = $(event.relatedTarget);  // Button that triggered the modal
//     var hotelId = button.data('hotel-id'); // Extract hotel id from data attribute
//     var modal = $(this);
    
//     // Set hotelId to the hidden input field
//     modal.find('#modalHotelId').val(hotelId);
//     console.log("Hotel ID being sent:", hotelId);

//     // Fetch room details using AJAX
//     $.ajax({
//       url: 'get_rooms_by_hotel.php',  // The server-side script to fetch rooms
//       method: 'POST',
//       data: { hotel_id: hotelId },
//       success: function(response) {
//         var rooms = JSON.parse(response);
//         var roomSelection = modal.find('#room-selection');
//         roomSelection.empty();  // Clear any existing options

//         // Add default option
//         roomSelection.append('<option value="" disabled selected>Select a Room</option>');
        
//         // Add new room options
//         rooms.forEach(function(room) {
//           var optionText = room.room_name + ' - ₹' + room.price_per_night + '/night';
//           if (room.discount > 0) {
//             optionText += ' (' + room.discount + '% off)';
//           }
//           roomSelection.append('<option value="' + room.roomId + '" data-price="' + room.price_per_night + '" data-occupancy="' + room.occupancy + '" data-discount="' + room.discount + '">' + optionText + '</option>');
//         });
//       },
//       error: function() {
//         alert('Failed to fetch room details.');
//       }
//     });
//   });
</script>
<script>
$(document).ready(function() {
    $('#property-search-form').on('submit', function(e) {
        e.preventDefault();
        let formData = $(this).serialize();

        $.ajax({
            url: 'property_search.php', // We'll create this next
            type: 'POST',
            data: formData,
            beforeSend: function() {
                $('#property-results').html('<div class="text-center w-100 py-5"><div class="spinner-border text-danger" role="status"></div></div>');
            },
            success: function(response) {
                $('#property-results').html(response);
            },
            error: function() {
                $('#property-results').html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
            }
        });
    });
  function calculateTotalAmount() {
    const selectedOption = $('#room-selection option:selected');
    const price = parseFloat(selectedOption.data('price')) || 0;
    const discount = parseFloat(selectedOption.data('discount')) || 0;
    const numRooms = parseInt($('#no-of-rooms').val()) || 0;

    const checkinDate = new Date($('#fromDate').val());
    const checkoutDate = new Date($('#toDate').val());

    if (!price || !numRooms || isNaN(checkinDate.getTime()) || isNaN(checkoutDate.getTime())) {
      $('#totalAmount').val('');
      return;
    }

    const timeDiff = checkoutDate - checkinDate;
    const nights = Math.ceil(timeDiff / (1000 * 60 * 60 * 24));

    if (nights <= 0) {
      $('#totalAmount').val('');
      return;
    }

    let total = price * numRooms * nights;

    if (discount > 0) {
      total = total - (total * discount / 100);
    }

    $('#totalAmount').val('₹' + total.toFixed(2));
    $('#total').val(total.toFixed(2));
  }

  // Trigger calculation on input changes
  $('#room-selection, #no-of-rooms, #fromDate, #toDate').on('change input', calculateTotalAmount);

});
</script>


