<?php
include('resources/header.php');
if (!isset($_GET['id']) || empty($_GET['id'])) {

    header("Location: index.php");
    exit();
}
$id = intval($_GET['id']); 
$resort_fetch_query=mysqli_query($conn,"SELECT * FROM add_package WHERE package_id = $id");
$property = mysqli_fetch_assoc($resort_fetch_query);

if (isset($_POST['book_package_now'])) {
 

    $packId = $_POST['packId'];
    $adultPrice = $_POST['pricePersonAdult'];
    $childPrice = $_POST['pricePersonChild'];
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $adults = $_POST['adults'];
    $children = $_POST['children'];
    $message = $_POST['message'];
    $totalAmount = preg_replace('/[^0-9.]/', '', $_POST['total_amount']); // remove ₹ symbol
    $payment_type=$_POST['payment_type'];
    
    if(empty($_POST['advance_amount']))
                {
                    $advance_amount=0;
                } else
                {
                $advance_amount=preg_replace('/[^0-9.]/', '',$_POST['advance_amount']);
                }
    

    // Insert booking
    $insertBookingQuery = "
        INSERT INTO package_bookings 
        (package_id, full_name, email, phone, adults, children, message, total_amount,paid_amount)
        VALUES
        ('$packId', '$name', '$email', '$phone', '$adults', '$children', '$message', '$totalAmount','$advance_amount')
    ";
    
    echo $insertBookingQuery;

    if ($conn->query($insertBookingQuery)) {
        $lastInsertedBookingId = $conn->insert_id;
        $bookingType = 'package_bookings';
        
        $result = $conn->query("SELECT MAX(CAST(SUBSTRING(invoice_number, 4) AS UNSIGNED)) AS last_invoice FROM invoices");
        $last_invoice_data = $result->fetch_assoc();
        $last_invoice_number = $last_invoice_data['last_invoice'] ?? 0;

        $invoiceNumber = 'INV' . str_pad($last_invoice_number + 1, 4, '0', STR_PAD_LEFT);

         $verificationCode = bin2hex(random_bytes(8)); // Generates a 16-character random hex string

        $insertInvoiceQuery = "
            INSERT INTO invoices (invoice_number, booking_type, booking_id,payment_type,advance_amount, verification_code)
            VALUES ('$invoiceNumber', '$bookingType', '$lastInsertedBookingId','$payment_type','$advance_amount','$verificationCode');
        ";

        if ($conn->query($insertInvoiceQuery)) {
            echo "<script>
                window.location.href = 'scan_package_payment.php?id=$invoiceNumber';
              //  invoice/index.php?id=$invoiceNumber
            </script>";
        } else {
            echo "<script>
                window.location.href = 'all-booking.php?Failed';
            </script>";
        }
    } else {
        echo "<script>
                window.location.href = 'all-booking.php?Failed';
            </script>";
    }

    $conn->close();
}
?>


<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">

<!-- ===============  breadcrumb area start =============== -->
    <div class="breadcrumb breadcrumb-style-one">
        <div class="container">
            <div class="col-lg-12 text-center">
                <h2 class="breadcrumb-title"><?php echo htmlspecialchars($property['package_title']); ?></h2>
                <ul class="d-flex justify-content-center breadcrumb-items">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">Tour Package</li>
                </ul>
            </div>
        </div>
    </div>
    <!-- ===============  breadcrumb area end =============== -->

    <div class="package-details-wrapper pt-76">
        <div class="container">
           <div class="row ">
               <div class="col-lg-8">
                <div class="tour-package-details">
                    <div class="pd-header">
             
                        <?php
                        $images = json_decode($property['package_image'], true);
                        ?>
                        <div id="packageCarousel" class="carousel slide" data-bs-ride="carousel">
                            <div class="carousel-inner">
                                <?php foreach ($images as $index => $imgPath): ?>
                                    <div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>">
                                        <img src="admin/dashboard/<?php echo $imgPath; ?>" class="d-block w-100" alt="Package Image">
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <button class="carousel-control-prev" type="button" data-bs-target="#packageCarousel" data-bs-slide="prev">
                                <span class="carousel-control-prev-icon"></span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#packageCarousel" data-bs-slide="next">
                                <span class="carousel-control-next-icon"></span>
                            </button>
                        </div>
                        <!--<div class="pd-thumb">-->
                        <!--    <img src="admin/dashboard/<?php echo $property['package_image']; ?>" alt="">-->
                        <!--</div>-->

                        <div class="header-bottom">
                            <div class="pd-lavel d-flex justify-content-between align-items-center flex-wrap gap-2">
                                
                            </div>
                            <h2 class="pd-title"><?php echo htmlspecialchars($property['package_title']); ?></h2>
                            <!--<h4 class="pt-3 text-bold"><?php echo $property['starting_from']; ?> to <?php echo $property['ending_at']; ?></h4>-->
                        </div>
                    </div>


                    <div class="package-details-tabs">

                          <div class="tab-content" id="pills-tabContent">

                             <!-- package info tab -->
                            <div class="tab-pane fade show active package-info-tab mt-3" id="pill-body1" role="tabpanel" aria-labelledby="pills-package1">
                                <h3 class="d-subtitle">Package Details</h3>
                                <p><?php echo $property['short_description']; ?></p>
                                <p><?php echo $property['detailed_itinerary']; ?></p>

                                <table class="table package-info-table mb-4 mb-sm-4">
                                    <tbody>
                                        <tr>
                                            <th>Duration</th>
                                            <td><?php echo $property['duration']; ?></td> <!-- Change to Homestay / Resort Room as needed -->
                                        </tr>
                                        <tr>
                                            <th>Price per Person(Adult)</th>
                                            <td><?php echo $property['person_price']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Price per Person(Child)</th>
                                            <td><?php echo $property['child_price']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Included</th>
                                            <td><?php echo $property['inclusions']; ?></td>
                                        </tr>
                                        
                                       <?php if ($property['group_discount'] == 'yes') : ?>
                                        <tr>
                                            <th>Discount</th>
                                            <td><?php echo isset($property['discount']) ? $property['discount'] . '%' : 'N/A'; ?></td>
                                            
                                            <?php if ($property['group_discount'] == 'yes' && isset($property['discount'])): ?>
                                                <input type="hidden" id="groupDiscountPercent" value="<?php echo $property['discount']; ?>">
                                            <?php endif; ?>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>


                
                                
                            </div>

                         
                          </div>
                    </div>
                </div>
               </div>

               <div class="col-lg-4">
                   <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-30">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Book This Package</h4>
                        </div>
                    
                        <div class="widget-body">
                            <form action="#" method="post" id="packageBookingForm">
                                <div class="booking-form-wrapper">
                                    <input type="hidden" name="packId" id="packId" value="<?php echo $property['package_id'] ?>">
                                    <input type="hidden" name="pricePersonAdult" id="pricePersonAdult" value="<?php echo $property['person_price'] ?>">
                                    <input type="hidden" name="pricePersonChild" id="pricePersonChild" value="<?php echo $property['child_price'] ?>">
                    
                                    <div class="custom-input-group">
                                        <input type="text" placeholder="Your Full Name" id="name" name="name" required>
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="email" placeholder="Your Email" id="email" name="email" required>
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="tel" placeholder="Phone" id="phone" name="phone" required>
                                    </div>
                    
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="custom-input-group">
                                                <i class="bi bi-chevron-down"></i>
                                                <select id="tourist-adult" name="adults" >
                                                    <option value="" disabled selected>Adult</option>
                                                    <?php for ($i = 1; $i <= 20; $i++): ?>
                                                        <option value="<?= $i ?>"><?= $i ?></option>
                                                    <?php endfor; ?>
                                                    
                                                </select>
                                            </div>
                                        </div>  
                                        <div class="col-sm-6">
                                            <div class="custom-input-group">
                                                <i class="bi bi-chevron-down"></i>
                                                <select id="tourist-child" name="children">
                                                    <option value="" disabled selected>Child</option>
                                                    <?php for ($i = 1; $i <= 20; $i++): ?>
                                                        <option value="<?= $i ?>"><?= $i ?></option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                    
                                    <div class="custom-input-group">
                                        <textarea name="message" cols="20" rows="7" placeholder="Your message"></textarea>
                                    </div>
                    
                                    <!-- Total Price Display -->
                                    <div class="custom-input-group">
                                        <input type="text" name="total_amount" id="total_amount" placeholder="Total Price" readonly>
                                        
                                    </div>
                                    
                                    <div class="custom-input-group">
                                        <label for="payment_type"><strong>Payment Type</strong></label>
                                        <select id="payment_type" name="payment_type" required>
                                            <option value="">Select Payment Type</option>
                                            <option value="full">Full Payment</option>
                                            <option value="advance">Advance Payment</option>
                                        </select>
                                    </div>
                                    <div class="custom-input-group" id="advanceAmountWrapper" style="display:none;">
                                        <label for="advance_amount"><strong>Advance Amount (30%) minimum</strong></label>
                                        <input type="text" id="advance_amount" name="advance_amount" />
                                        <span id="advance_notice" style="color: #e74c3c; font-size: 14px;"></span>
                                    </div>
                                    <div class="custom-input-group">
                                        <div class="submite-btn">
                                            <button type="submit" name="book_package_now">Book Now</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </aside>

                   </div>
               </div>
           </div>
        </div>
    </div>
   
<?php
include('./resources/footer.php');
?>
<script>
function calculatePackageTotal() {
    const adultCount = parseInt(document.getElementById('tourist-adult').value) || 0;
    const childCount = parseInt(document.getElementById('tourist-child').value) || 0;
    const adultPrice = parseFloat(document.getElementById('pricePersonAdult').value) || 0;
    const childPrice = parseFloat(document.getElementById('pricePersonChild').value) || 0;
    const discountInput = document.getElementById('groupDiscountPercent');
    const paymentType = document.getElementById('payment_type').value;

    let total = (adultCount * adultPrice) + (childCount * childPrice);

    if (discountInput) {
        const discountPercent = parseFloat(discountInput.value) || 0;
        const discountAmount = total * (discountPercent / 100);
        total -= discountAmount;
    }

    // Update total field
    document.getElementById('total_amount').value = '₹' + total.toFixed(2);

    // Advance logic
    const advanceWrapper = document.getElementById('advanceAmountWrapper');
    const advanceNotice = document.getElementById('advance_notice');

    if (paymentType === 'advance') {
        const advance = (total * 0.30).toFixed(2);
        advanceNotice.textContent = 'Minimum Advance Amount: ₹' + advance;
        advanceWrapper.style.display = 'block';
    } else {
        advanceNotice.textContent = '';
        advanceWrapper.style.display = 'none';
    }
}


document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('tourist-adult').addEventListener('change', calculatePackageTotal);
    document.getElementById('tourist-child').addEventListener('change', calculatePackageTotal);
    document.getElementById('payment_type').addEventListener('change', calculatePackageTotal);
});
</script>



