<?php
include('resources/header.php');
$where = "WHERE property_Type='Homestay' AND status='1'";

if (!empty($_GET['spot'])) {
    $spot = mysqli_real_escape_string($conn, $_GET['spot']);
    $where .= " AND FIND_IN_SET('$spot', choose)";
}

if (!empty($_GET['car_name'])) {
    $name = mysqli_real_escape_string($conn, $_GET['car_name']);
    $where .= " AND name LIKE '%$name%'";
}

$limit = 9;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;
$offset = ($page - 1) * $limit;

$countQuery = "SELECT COUNT(*) as total FROM Hotel_Add $where";
$countResult = mysqli_query($conn, $countQuery);
$totalResorts = mysqli_fetch_assoc($countResult)['total'];
$totalPages = ceil($totalResorts / $limit);

$resort_fetch_query = mysqli_query($conn, "SELECT * FROM Hotel_Add $where LIMIT $limit OFFSET $offset");

$spots = [];
$joining_query = mysqli_query($conn, "SELECT tours.state AS state_name, spots.* FROM spots JOIN tours ON tours.id = spots.tour_id");
while ($row = mysqli_fetch_assoc($joining_query)) {
    $spots[] = [
        'spotId' => $row['spotId'],
        'spot' => $row['spot'],
        'state' => $row['state_name']
    ];
}
?>
<style>
.page-item.active .page-link {
    z-index: 3;
    color: #fff;
    background-color: #eb5744;
    border-color: #dc3545;
}
.page-link {
    color: #dc3545;
}
</style>
<!-- ===============  breadcrumb area start =============== -->
<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Homestays</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Homestays</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->
<!-- =============== package area start =============== -->
<div class="package-area package-style-one pt-110 ">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <div class="section-head-alpha" style=" max-width: none;">
                    <h2>Popular Homestays</h2>
                    <p>From beachfront villas to hilltop retreats, our curated selection of resorts offers something for every traveler. Whether you're seeking adventure or relaxation, find the perfect escape to unwind and enjoy the serene beauty of nature.</p>
                </div>
            </div>
        </div>
        <form method="GET" class="mb-5">
            <div class="bg-light p-4 rounded shadow-sm">
                <div class="d-flex flex-wrap align-items-end gap-3">
                    <div class="flex-grow-1">
                        <select class="form-select form-control-modern" name="state" id="stateSelect">
                            <option value="">Choose State</option>
                            <?php
                            $states = array_unique(array_column($spots, 'state'));
                            foreach ($states as $state) {
                                $selected = (isset($_GET['state']) && $_GET['state'] == $state) ? 'selected' : '';
                                echo "<option value=\"$state\" $selected>$state</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div class="flex-grow-1">
                        <select class="form-select form-control-modern" id="spotSelect" name="spot">
                            <option value="">Choose Spot</option>
                        </select>
                    </div>
                    <div class="flex-grow-1">
                        <input type="text" class="form-control form-control-modern" name="car_name" placeholder="Property Name" value="<?php echo isset($_GET['car_name']) ? htmlspecialchars($_GET['car_name']) : ''; ?>">
                    </div>
                    <div>
                        <button type="submit" class="btn btn-danger rounded-pill px-4">
                            <i class="bi bi-search"></i>
                        </button>
                    </div>
                </div>
            </div>
        </form>
        <div class="row g-4">
            <?php if (mysqli_num_rows($resort_fetch_query) > 0): ?>
                <?php while ($resort = mysqli_fetch_assoc($resort_fetch_query)): ?>
                    <div class="col-lg-4 col-md-6 mb-4">
                        <div class="package-card-alpha">
                            <?php
                            $coverImage = 'admin/dashboard/' . $resort['cover_img'];
                            $defaultImage = 'assets/images/resort.jpg';
                            if (empty($resort['cover_img']) || !file_exists($coverImage)) {
                                $coverImage = $defaultImage;
                            }
                            ?>
                            <div class="package-thumb">
                                <a href="property-details.php?id=<?php echo $resort['hotel_id']; ?>&type=Homestay">
                                    <img src="<?php echo $coverImage; ?>" alt="" style="height: 300px;">
                                </a>
                            </div>
                            <div class="package-card-body" style="height: 215px;">
                                <h3 class="p-card-title">
                                    <a href="property-details.php?id=<?php echo $resort['hotel_id']; ?>&type=Homestay">
                                        <?php echo $resort['name']; ?>
                                    </a>
                                </h3>
                                <p> <?php
                                $words = explode(' ', $resort['short_Description']);
                                $short_text = implode(' ', array_slice($words, 0, 15));
                                echo $short_text . (count($words) > 15 ? '...' : '');
                              ?></p>
                                <div class="p-card-bottom">
                                    <div class="book-btn">
                                        <a href="property-details.php?id=<?php echo $resort['hotel_id']; ?>&type=Homestay">Book Now <i class='bx bxs-right-arrow-alt'></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="col-12 text-center py-5">
                    <h5 class="text-muted">No homestays found in this location.</h5>
                </div>
            <?php endif; ?>
        </div>
        <?php if ($totalPages > 1): ?>
            <div class="text-center mb-4">
                <nav>
                    <ul class="pagination justify-content-center">
                        <?php if ($page > 1): ?>
                            <li class="page-item"><a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&laquo; Prev</a></li>
                        <?php endif; ?>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?php echo $page == $i ? 'active' : ''; ?>">
                                <a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>"><?php echo $i; ?></a>
                            </li>
                        <?php endfor; ?>
                        <?php if ($page < $totalPages): ?>
                            <li class="page-item"><a class="page-link" href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">Next &raquo;</a></li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        <?php endif; ?>
    </div>
</div>
<!-- =============== package area end =============== -->
<?php include('./resources/footer.php'); ?>
<script>
    const spots = <?php echo json_encode($spots); ?>;
    const stateSelect = document.getElementById('stateSelect');
    const spotSelect = document.getElementById('spotSelect');
    const selectedSpot = '<?php echo isset($_GET['spot']) ? $_GET['spot'] : ''; ?>';

    function populateSpots(state = '') {
        spotSelect.innerHTML = '<option value="">Choose Spot</option>';
        const filtered = state ? spots.filter(s => s.state === state) : spots;
        filtered.forEach(s => {
            const opt = document.createElement('option');
            opt.value = s.spotId;
            opt.textContent = s.spot;
            if (s.spotId === selectedSpot) opt.selected = true;
            spotSelect.appendChild(opt);
        });
    }

    populateSpots('<?php echo isset($_GET['state']) ? $_GET['state'] : ''; ?>');

    stateSelect.addEventListener('change', () => {
        populateSpots(stateSelect.value);
    });
</script>
