<?php
include('./config/dbcon.php');

// Get the booking ID, new status, and booking type from the AJAX request
if (isset($_POST['id']) && isset($_POST['status']) && isset($_POST['booking_type'])) {
    $id = $_POST['id'];
    $status = $_POST['status'];
    $bookingType = $_POST['booking_type'];

    // Sanitize inputs
    $id = intval($id);
    $status = mysqli_real_escape_string($conn, $status);
    $bookingType = mysqli_real_escape_string($conn, $bookingType);

    // Determine which table to update based on the booking type
    switch ($bookingType) {
        case 'package':
            $table = 'package_bookings';
            break;
        case 'property':
            $table = 'property_bookings';
           
            break;
        case 'car':
            $table = 'car_bookings';
            break;
        default:
            echo json_encode(['success' => false]);
            exit;
    }

    // Update the status in the correct table
    $updateQuery = "UPDATE $table SET status = '$status' WHERE id = $id";

    if (mysqli_query($conn, $updateQuery)) {
      //  echo json_encode(['success' => true]);
        // echo json_encode(['success' => true, 'message' => $updateQuery]);
    } else {
     //   echo json_encode(['success' => false]);
    }
} else {
   // echo json_encode(['success' => false]);
}


if (isset($_POST['package_id'], $_POST['package_status'], $_POST['booking_type'])) {
    $id = (int) $_POST['package_id'];
    $status = trim($_POST['package_status']);
    $bookingType = trim($_POST['booking_type']);

    $allowedStatuses = ['pending', 'confirm', 'reject', 'refund'];

    if (!in_array($status, $allowedStatuses)) {
        echo json_encode(['success' => false, 'message' => 'Invalid status.']);
        exit;
    }

    switch ($bookingType) {
        case 'package':
            $table = 'package_bookings';
            break;
        case 'property':
            $table = 'property_bookings';
            break;
        case 'car':
            $table = 'car_bookings';
            break;
        default:
            echo json_encode(['success' => false, 'message' => 'Invalid booking type.']);
            exit;
    }

    $stmt = mysqli_prepare($conn, "UPDATE `$table` SET payment_status = ? WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'si', $status, $id);
        if (mysqli_stmt_execute($stmt)) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Database update failed']);
        }
        mysqli_stmt_close($stmt);
    } else {
        echo json_encode(['success' => false, 'message' => 'Query preparation failed']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Missing parameters']);
}

?>
