<?php
include('./config/dbcon.php');

// Handle form submission
if (isset($_POST['testimonial_submit'])) {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $designation = mysqli_real_escape_string($conn, $_POST['designation']);
    $message = mysqli_real_escape_string($conn, $_POST['message']);

    mysqli_query($conn, "INSERT INTO testimonial (name, designation, message) 
                         VALUES ('$name', '$designation', '$message')");
    header('Location: testimonial.php');
    exit(); // important to stop further execution
}

// Handle deletion
if (isset($_GET['delete_id'])) {
    $id = intval($_GET['delete_id']);
    mysqli_query($conn, "DELETE FROM testimonial WHERE id = $id");
    header('Location: testimonial.php');
    exit();
}

// Fetch data only after possible actions
$query = mysqli_query($conn, "SELECT * FROM testimonial");
?>

<?php include('./resources/header.php'); ?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default d-flex justify-content-between">
                <h3 class="block-title">Testimonials</h3>
            </div>
            <div class="block-content">
                <form method="POST" action="" enctype="multipart/form-data" class="mb-4">
                    <div class="row push ms-1">
                        
                        <div class="col-md-12 mb-3">
                            <textarea class="form-control" name="message" placeholder="Testimonial Message" required></textarea>
                        </div>
                        <div class="col-md-5 mb-3">
                            <input type="text" class="form-control" name="name" placeholder="Name" required>
                        </div>
                        <div class="col-md-5 mb-3">
                            <input type="text" class="form-control" name="designation" placeholder="Designation" required>
                        </div>
                        <div class="col-md-2 mb-3">
                            <button type="submit" name="testimonial_submit" class="btn btn-primary w-100">Add</button>
                        </div>
                    </div>
                </form>
            </div>

            <table class="table table-bordered table-striped table-vcenter">
                <thead>
                    <tr>
                        <th class="text-center" width="5%">#</th>
                        <th width="15%">Name</th>
                        <th width="15%">Designation</th>
                        <th>Message</th>
                        <th width="10%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; while($row = mysqli_fetch_assoc($query)) { ?>
                        <tr>
                            <td class="text-center"><?= $i++ ?></td>
                            <td><?= $row['name'] ?></td>
                            <td><?= $row['designation'] ?></td>
                            <td><?= $row['message'] ?></td>
                            <td class="text-center">
                                <a href="testimonial.php?delete_id=<?= $row['id'] ?>"
                                   class="btn btn-sm btn-danger"
                                   onclick="return confirm('Are you sure you want to delete this testimonial?')">
                                    <i class="fa fa-trash-alt"></i>
                                </a>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<?php include('./resources/footer.php'); ?>
