<?php
include('./resources/header.php');
include('./config/dbcon.php');

// Pagination setup
$limit = 10;
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset = ($page - 1) * $limit;

// Get total records
$count_query = mysqli_query($conn, "SELECT COUNT(*) as total FROM room_details");
$total_row = mysqli_fetch_assoc($count_query);
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $limit);

// Main paginated query
$joining_query = mysqli_query($conn, "
    SELECT 
        Hotel_Add.name AS property_name, 
        room_details.*
    FROM 
        room_details
    JOIN 
        Hotel_Add ON Hotel_Add.hotel_id = room_details.hotel_id
    LIMIT $offset, $limit
");
?>

<!-- Main Container -->
    <main id="main-container">
        <!-- Hero -->
        <div class="content">
            <!-- Dynamic Table Full -->
          <div class="block block-rounded">
            <div class="block-header block-header-default">
              <h3 class="block-title">
                List <small>of </small>Rooms
              </h3>
            </div>
            <div class="block-content block-content-full">
             <div class="table-responsive">
              <table class="table table-bordered table-striped table-vcenter ">
                <thead>
                  <tr>
                    <th class="d-sm-table-cell" style="width:5%;">Sr No.</th>
                    <th class="d-sm-table-cell" style="width: 30%;">Room Name</th>
                    <th class=" d-sm-table-cell" style="width: 30%;">Property Name</th>
                    <th class=" d-sm-table-cell" style="width: 15%;">Price per night</th>
                     
                      <th class=" d-sm-table-cell" style="width: 15%;">Action</th>
                       <!--<th class=" d-sm-table-cell" style="width: 15%;"></th>-->
                    <th class=" d-sm-table-cell"style="width: 15%;">Status</th>
                  </tr>
                </thead>
                <tbody>
                    <?php  $sl=0; while($sql_fetch=mysqli_fetch_assoc($joining_query)) { ?>
                  <tr>
                    <td class="text-center"><?php echo $offset + $sl + 1; $sl++; ?></td>
                    <td class="fw-semibold">
                        
                      <?php echo $sql_fetch['room_name']?>
                    </td>
                    <td class=" d-sm-table-cell">
                       <?php echo $sql_fetch['property_name']?>
                    </td>
                    <td class=" d-sm-table-cell">
                      <?php echo $sql_fetch['price_per_night']?>
                    </td>
                                        
                                        <!--<td class="d-none d-sm-table-cell">-->
  <!--<a href="edit_hotel_details.php?ep=<?php echo $sql_fetch['hotel_id']?>"-->
     <!--style="background-color: 	#FFBF00; border-radius: 8px; padding: 6px 12px; color: #F9F6EE; font-weight: bold; text-decoration: none; display: inline-block;"-->
     <!--onmouseover="this.style.backgroundColor='#E49B0F';"-->
     <!--onmouseout="this.style.backgroundColor='#FFBF00';">-->
    <!--Edit-->
  <!--</a>-->
<!--</td>-->
                                        <td class=" d-sm-table-cell"><center>
                      <a href="display_room_details.php?ep=<?php echo $sql_fetch['roomId']?>" style="background-color: #228B22; border-radius: 8px; padding: 6px 12px; color: #F9F6EE; font-weight: bold; text-decoration: none; display: inline-block; margin-bottom:2px;"
     onmouseover="this.style.backgroundColor='#097969';"
     onmouseout="this.style.backgroundColor='#228B22';"><i class="fa-solid fa-pen-to-square"></i></a>
     
     <a href="delete_rooms.php?ep=<?php echo $sql_fetch['roomId']?>" 
     onclick="return confirm('Are you sure you want to delete this room?');"
     style="background-color: #FA8072; border-radius: 8px; padding: 6px 12px; color: #F9F6EE; font-weight: bold; text-decoration: none; display: inline-block;"
     onmouseover="this.style.backgroundColor='#CD5C5C';"
     onmouseout="this.style.backgroundColor='#FA8072';"><i class="fa-solid fa-trash"></i></a>
     </center>
                    </td>
                    <td class=" d-sm-table-cell"><center>
                      <button class="btn btn-sm toggle-status" 
                               data-id="<?= $sql_fetch['roomId']; ?>" 
                               data-status="<?= $sql_fetch['status']; ?>" 
                               style="background-color:<?= $sql_fetch['status'] == 1 ? '#0d6efd' : '#dc3545'; ?>; color:white;">
                              <?= $sql_fetch['status'] == 1 ? 'Active' : 'Inactive'; ?>
                         </button>
                      </center>
                    </td>
                  </tr>
                  
                </tbody>
                <?php 
                }?>
              </table>
              <!-- Pagination -->
                <nav aria-label="Page navigation">
                  <ul class="pagination justify-content-center">
                    <?php if ($page > 1): ?>
                      <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>">Previous</a></li>
                    <?php endif; ?>
                
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                      <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                      </li>
                    <?php endfor; ?>
                
                    <?php if ($page < $total_pages): ?>
                      <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>">Next</a></li>
                    <?php endif; ?>
                  </ul>
                </nav>

              </div>
            </div>
          </div>
          <!-- END Dynamic Table Full -->
        </div>
        
    </main>
    
<?php
include('./resources/footer.php');
?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
  $('.toggle-status').on('click', function(){
    var button = $(this);
    var roomId = button.data('id');
    var currentStatus = button.data('status');

    $.ajax({
      url: 'update_status.php', // Backend PHP script
      type: 'POST',
      data: {
        roomid: roomId,
        status: currentStatus,
      },
      success: function(response){
        // Toggle status and button UI
        var newStatus = (currentStatus == 1) ? 0 : 1;
        button.data('status', newStatus);
        button.text(newStatus == 1 ? 'Active' : 'Inactive');
        button.css('background-color', newStatus == 1 ? '#0d6efd' : '#dc3545');
      }
    });
  });
});
</script>
