<?php
include('./resources/header.php');
include('config/dbcon.php');

// Fetch SEO data for the home page
$query = mysqli_query($conn, "SELECT * FROM seo_pages WHERE page_name = 'cars'");
$seo_data = mysqli_fetch_assoc($query);
$seo_id = $seo_data['id'];
?>

<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Edit Cars SEO</h3>
            </div>
            <div class="block-content">
                <form class="mb-4" method="POST" action="action.php">
                    <input type="hidden" name="seo_id" value="<?php echo $seo_id; ?>">

                    <div class="row push">
                        <div class="mb-4 col-12">
                            <label class="form-label" for="meta_title">Meta Title</label>
                            <input type="text" class="form-control" id="meta_title" name="meta_title"
                                placeholder="Enter Meta Title" value="<?php echo $seo_data['meta_title']; ?>" required>
                        </div>

                        <div class="mb-4 col-12">
                            <label class="form-label" for="meta_description">Meta Description</label>
                            <textarea class="form-control" id="meta_description" name="meta_description" rows="4" required><?php echo $seo_data['meta_description']; ?></textarea>
                        </div>

                        <div class="mb-4 col-12">
                            <label class="form-label" for="meta_keywords">Meta Keywords</label>
                            <textarea class="form-control" id="meta_keywords" name="meta_keywords" rows="3" required><?php echo $seo_data['meta_keywords']; ?></textarea>
                        </div>

                        <div class="col-12 text-center">
                            <button type="submit" name="seo_update_cars" value="seo_update_cars" class="btn btn-primary">Update SEO</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>

<?php include('./resources/footer.php'); ?>
