<?php
include('./resources/header.php');
include('config/dbcon.php');
$choose_spot=mysqli_query($conn,"SELECT * FROM spots");
?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Add Property</h3>
                
            </div>
            <div class="block-content">
                <form class="mb-4" action="insert_Action.php" method="POST" enctype="multipart/form-data" onsubmit="return validateValues()">
                    <h2 class="content-heading">Basic Information</h2>
                     
                    <div class="row push mx-4">
                        <div class="row overflow-hidden">
                            <div class="mb-4 col-lg-4 col-sm-12">
                                <label class="form-label" for="property_type">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                            <div class="mb-4 col-lg-4 col-sm-12">
                                <label class="form-label" for="property_type">Property Type</label>
                                <select class="form-select" id="property_type" name="property_type">
                                    <option value="">Open this select menu</option>
                                    <option value="hotel">Hotel</option>
                                    <option value="homestay">Homestay</option>
                                    <option value="resort">Resort</option>
                                </select>
                                 <span id="property_type_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-4 col-sm-12">
                                <label class="form-label" for="name">Name</label>
                                <input type="text" class="form-control" id="name" name="name" placeholder="Enter name..">
                                <span id="property_name_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="sDescription">Short Description</label>
                                    <textarea class="form-control" id="short_description" name="short_description"placeholder="enter short description"></textarea>
                                    
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="fDescription">Full Description</label>
                                     <textarea class="form-control" id="simplemde" name="full_description"placeholder="enter full description"></textarea>
                                     
                                
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="manager_name">Property Owner/Manager Name</label>
                                <input type="text" class="form-control" id="manager_name" name="manager_name"
                                    placeholder="Enter manager name..">
                                    <span id="manager_name_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email..">
                                <span id="email_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="phoneNo">Phone Number</label>
                                <input type="number" class="form-control" id="phoneNo" name="phoneNo" placeholder="Enter Phone No..">
                                <span id="phoneNo_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="altPhoneNo">Alternative Phone Number</label>
                                <input type="number" class="form-control" id="altPhoneNo" name="altPhoneNo"
                                    placeholder="Enter Phone No..">
                                    
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Address and Location</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="street">Street Address</label>
                                <input type="text" class="form-control" id="street" name="street" placeholder="Enter street Address..">
                                <span id="street_address_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" placeholder="Enter City name..">
                                <span id="city_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                              <label class="form-label" for="state">Choose State</label>
                              <select class="form-select" id="state" name="state">
                                <option value="">Choose State</option>
                                <option value="Andaman and Nicobar Islands">Andaman and Nicobar Islands</option>
                                <option value="Andhra Pradesh">Andhra Pradesh</option>
                                <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                                <option value="Assam">Assam</option>
                                <option value="Bihar">Bihar</option>
                                <option value="Chandigarh">Chandigarh</option>
                                <option value="Chhattisgarh">Chhattisgarh</option>
                                <option value="Dadra and Nagar Haveli and Daman and Diu">Dadra and Nagar Haveli and Daman and Diu</option>
                                <option value="Delhi">Delhi</option>
                                <option value="Goa">Goa</option>
                                <option value="Gujarat">Gujarat</option>
                                <option value="Haryana">Haryana</option>
                                <option value="Himachal Pradesh">Himachal Pradesh</option>
                                <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                                <option value="Jharkhand">Jharkhand</option>
                                <option value="Karnataka">Karnataka</option>
                                <option value="Kerala">Kerala</option>
                                <option value="Ladakh">Ladakh</option>
                                <option value="Lakshadweep">Lakshadweep</option>
                                <option value="Madhya Pradesh">Madhya Pradesh</option>
                                <option value="Maharashtra">Maharashtra</option>
                                <option value="Manipur">Manipur</option>
                                <option value="Meghalaya">Meghalaya</option>
                                <option value="Mizoram">Mizoram</option>
                                <option value="Nagaland">Nagaland</option>
                                <option value="Odisha">Odisha</option>
                                <option value="Puducherry">Puducherry</option>
                                <option value="Punjab">Punjab</option>
                                <option value="Rajasthan">Rajasthan</option>
                                <option value="Sikkim">Sikkim</option>
                                <option value="Tamil Nadu">Tamil Nadu</option>
                                <option value="Telangana">Telangana</option>
                                <option value="Tripura">Tripura</option>
                                <option value="Uttar Pradesh">Uttar Pradesh</option>
                                <option value="Uttarakhand">Uttarakhand</option>
                                <option value="West Bengal">West Bengal</option>
                              </select>
                              <span id="state_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="pin">PIN/ZIP Code</label>
                                <input type="number" class="form-control" id="pin" name="pin" placeholder="Enter Pin..">
                                <span id="pin_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="country">Country</label>
                                <input type="text" class="form-control" id="country" name="country" placeholder="Enter Country name..">
                                <span id="country_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12 ">
                                <label class="form-label" for="tour_spot">Tour Spot</label>
                                <select class="form-select" id="tour_spot" name="tour_spot">
                                    <?php
                                 // Loop through each spot and create an option
                                        while ($row = mysqli_fetch_assoc($choose_spot)) {
                                echo '<option value="' . $row['spotId'] . '">' . htmlspecialchars($row['spot']) . '</option>';
                                   }
                                   ?>
                                </select>
                                <span id="tour_spot_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                        </div>
                    </div>

                    <h2 class="content-heading">Property Features/Facilities</h2>
                    <div class="row push mx-4">
                        <div class="col-12 overflow-hidden">
                            <div class="mb-4">
                                <div class="space-y-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="wifi" id="wifi" name="wifi">
                                        <label class="form-check-label" for="wifi">Free Wifi</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="parking" id="parking" name="parking">
                                        <label class="form-check-label" for="parking">Free parking</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="breakfast" id="breakfast" name="breakfast">
                                        <label class="form-check-label" for="breakfast">Breakfast Included</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="pool" id="pool" name="pool">
                                        <label class="form-check-label" for="pool">Swimming Pool</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="garden" id="garden" name="garden">
                                        <label class="form-check-label" for="garden">Garden</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="view" id="view" name="view">
                                        <label class="form-check-label" for="view">Mountain/River/Beach View</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="reception" id="reception" name="reception">
                                        <label class="form-check-label" for="reception">24/7 Reception</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="housekeeping" id="housekeeping" name="housekeeping">
                                        <label class="form-check-label" for="housekeeping">Housekeeping</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="bonfire" id="bonfire" name="bonfire">
                                        <label class="form-check-label" for="bonfire">Bonfire Facility</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="activities" id="activities" name="activities">
                                        <label class="form-check-label" for="activities">Activities (e.g., Trekking, Boating)</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="games" id="games" name="games">
                                        <label class="form-check-label" for="games">Outdoor Games</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="hall" id="hall" name="hall">
                                        <label class="form-check-label" for="hall">Conference Hall</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="dinning" id="dinning" name="dinning">
                                        <label class="form-check-label" for="dinning">Restaurant / In-House Dining</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="kitchen" id="kitchen_access" name="kitchen_access">
                                        <label class="form-check-label" for="kitchen_access">Kitchen Access</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="pet" id="pet" name="pet">
                                        <label class="form-check-label" for="pet">Pet-Friendly</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="family" id="family" name="family">
                                        <label class="form-check-label" for="family">Family Friendly</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="couple" id="couple" name="couple">
                                        <label class="form-check-label" for="couple">Couple Friendly</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="wheelchair" id="wheelchair" name="wheelchair">
                                        <label class="form-check-label" for="wheelchair">Wheelchair Accessible</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h2 class="content-heading">Photos/Media</h2>
                    <div class="row push mx-4">
                        <div class=" row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="cover_image">Cover Image</label>
                                <input class="form-control" type="file" id="cover_image" name="cover_image">
                                <span id="cover_image_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            
                        </div>
                    </div>

                    <h2 class="content-heading">Policies</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="checkIn">Checking-In Time</label>
                                <input type="time" class="form-control" id="checkIn" name="checkIn" placeholder="Time format - hh:mm:ss">
                                <span id="checkIn_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="checkOut">Check-Out Time</label>
                                <input type="time" class="form-control" id="checkOut" name="checkOut" placeholder="Time format - hh:mm:ss">
                                <span id="checkOut_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="cancellation">Cancellation Policy</label>
                                <input type="text" class="form-control" id="cancellation" name="cancellation" placeholder="Enter Cancellation Policy">
                                
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="smoking">Smoking Policy</label>
                                <input type="text" class="form-control" id="smoking" name="smoking" placeholder="Enter smoking policy">
                            </div>
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="pet_policy">Pet Policy</label>
                                <input type="text" class="form-control" id="pet_policy" name="pet_policy" placeholder="Enter pet policy">
                            </div>
                            
                            <div class="mb-4 col-lg-12 col-sm-12">
                                        <label class="form-label col-sm-12 col-lg-12" for="Payment Methods">Payment Methods:-</label>
                                         <div class="d-block d-md-inline">
                                        <input class="form-check-input col-sm-12" type="checkbox" value="Cash" id="payment" name="payment[]">
                                        <label class="form-check-label " for="cash">Cash</label>
                                        </div>
                                       <div class="d-block d-md-inline">
                                         <input class="form-check-input col-sm-12" type="checkbox" value="Card" id="payment" name="payment[]">
                                        <label class="form-check-label " for="card">Card</label>
                                        </div>
                                        <div class="d-block d-md-inline">
                                        <input class="form-check-input col-sm-12 " type="checkbox" value="UPI" id="payment" name="payment[]">
                                        <label class="form-check-label " for="upi">UPI</label>
                                        </div>
                                        <div class="d-block d-md-inline">
                                        <input class="form-check-input col-sm-12" type="checkbox" value="Bank Transfer" id="payment" name="payment[]">
                                        <label class="form-check-label " for="Bank Transfer">Bank Transfer</label>
                                        </div>
                            </div>
                        </div>
                    </div>

                    <h2 class="content-heading">SEO and Tags</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="meta_title">Meta Title</label>
                                <input type="text" class="form-control" id="meta_title" name="meta_title" placeholder="Enter Meta Title">
                                <span id="meta_title_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="tags">Tags/Keywords </label>
                                <input type="text" class="form-control" id="tags" name="tags" placeholder="Enter Tags/Keywords">
                                <span id="tags_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            
                            <div class="mb-4 col-lg-12 col-sm-12">
                  <!-- SimpleMDE Container -->
                  <label class="form-label" for="meta_title">Meta Description</label>
                  <textarea class="form-control" id="simplemde" name="meta_description"placeholder="enter meta description"></textarea>
                  
                </div>
                            
                            
                        </div>
                    </div>

                    
                    <div class="mb-4 col-lg-12 col-sm-12 p-5">
               <button type="submit" name="submit" value="submit" class="btn btn-primary w-100">Save</button>
                 </div>
                </form>
            </div>
        </div>
    </div>
</main>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let roomCounter = 2;
        const roomDetailsContainer = document.getElementById('room_details_container');
        const addRoomButton = document.getElementById('add_room_button');

        addRoomButton.addEventListener('click', function() {
            const newRoomBlock = document.createElement('div');
            newRoomBlock.classList.add('block', 'block-rounded', 'mb-4');
            newRoomBlock.innerHTML = `
                <div class="block-header block-header-default">
                    <h3 class="block-title">Room ${roomCounter}</h3>
                </div>
                <div class="block-content">
                    <div class="mb-4">
                        <label class="form-label">Basic Info.</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_name_${roomCounter}">Room Name</label>
                        <input type="text" class="form-control" id="room_name_${roomCounter}" name="room[${roomCounter}][name]" placeholder="Enter room name">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_description_${roomCounter}">Room Description</label>
                        <input type="text" class="form-control" id="room_description_${roomCounter}" name="room[${roomCounter}][description]" placeholder="Enter room description">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="room_size_${roomCounter}">Room Size (sq ft or sqm)</label>
                        <input type="text" class="form-control" id="room_size_${roomCounter}" name="room[${roomCounter}][size]" placeholder="Enter room size">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="occupancy_limit_${roomCounter}">Occupancy Limit</label>
                        <input type="number" class="form-control" id="occupancy_limit_${roomCounter}" name="room[${roomCounter}][occupancy]" placeholder="Enter occupancy limit">
                    </div>
                    <div class="mb-4">
                        <label class="form-label">Extra Person Allowed</label>
                        <div class="space-x-2">
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_yes_${roomCounter}" name="room[${roomCounter}][extra_person]" value="yes">
                                <label class="form-check-label" for="extra_person_yes_${roomCounter}">Yes</label>
                            </div>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="extra_person_no_${roomCounter}" name="room[${roomCounter}][extra_person]" value="no" checked>
                                <label class="form-check-label" for="extra_person_no_${roomCounter}">No</label>
                            </div>
                        </div>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="extra_charges_${roomCounter}">Extra Charges Per Person</label>
                        <input type="number" class="form-control" id="extra_charges_${roomCounter}" name="room[${roomCounter}][extra_charges]" placeholder="Enter extra charges (optional)">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Pricing</label>
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="price_per_night_${roomCounter}">Price per Night</label>
                        <input type="number" class="form-control" id="price_per_night_${roomCounter}" name="room[${roomCounter}][price]" placeholder="Enter price per night">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="discount_${roomCounter}">Discount / Offer %<small>(optional)</small></label>
                        <input type="number" class="form-control" id="discount_${roomCounter}" name="room[${roomCounter}][discount]" placeholder="Enter discount percentage">
                    </div>
                    <div class="mb-4">
                        <label class="form-label" for="cleaning_fee_${roomCounter}">Cleaning Fee<small>(optional)</small></label>
                        <input type="number" class="form-control" id="cleaning_fee_${roomCounter}" name="room[${roomCounter}][cleaning_fee]" placeholder="Enter cleaning fee">
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Amenities</label>
                        <div class="space-y-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="attached_bathroom_${roomCounter}" name="room[${roomCounter}][amenities][]" value="attached_bathroom">
                                <label class="form-check-label" for="attached_bathroom_${roomCounter}">Attached Bathroom</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="ac_${roomCounter}" name="room[${roomCounter}][amenities][]" value="ac">
                                <label class="form-check-label" for="ac_${roomCounter}">Air Conditioner</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="heater_${roomCounter}" name="room[${roomCounter}][amenities][]" value="heater">
                                <label class="form-check-label" for="heater_${roomCounter}">Heater</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="tv_${roomCounter}" name="room[${roomCounter}][amenities][]" value="tv">
                                <label class="form-check-label" for="tv_${roomCounter}">TV</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="geyser_${roomCounter}" name="room[${roomCounter}][amenities][]" value="geyser">
                                <label class="form-check-label" for="geyser_${roomCounter}">Geyser</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="kitchen_access_room_${roomCounter}" name="room[${roomCounter}][amenities][]" value="kitchen_access">
                                <label class="form-check-label" for="kitchen_access_room_${roomCounter}">Kitchen Access</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="towels_${roomCounter}" name="room[${roomCounter}][amenities][]" value="towels">
                                <label class="form-check-label" for="towels_${roomCounter}">Towels/Toiletries</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="balcony_${roomCounter}" name="room[${roomCounter}][amenities][]" value="balcony">
                                <label class="form-check-label" for="balcony_${roomCounter}">Private Balcony / Garden View</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="wardrobe_${roomCounter}" name="room[${roomCounter}][amenities][]" value="wardrobe">
                                <label class="form-check-label" for="wardrobe_${roomCounter}">Wardrobe</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="desk_${roomCounter}" name="room[${roomCounter}][amenities][]" value="desk">
                                <label class="form-check-label" for="desk_${roomCounter}">Desk & Chair</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="fridge_${roomCounter}" name="room[${roomCounter}][amenities][]" value="fridge">
                                <label class="form-check-label" for="fridge_${roomCounter}">Mini Fridge</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="room_service_${roomCounter}" name="room[${roomCounter}][amenities][]" value="room_service">
                                <label class="form-check-label" for="room_service_${roomCounter}">Room Service</label>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Room Images</label>
                        <input class="form-control mb-2" type="file" name="room_images[${roomCounter}][]" multiple>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="public_private_${roomCounter}" name="room[${roomCounter}][public_private]" value="private">
                            <label class="form-check-label" for="public_private_${roomCounter}">Private</label>
                        </div>
                    </div>
                </div>
            `;
            roomDetailsContainer.appendChild(newRoomBlock);
            roomCounter++;
        });
    });
    function validateValues() {
    // Reset all error messages
    var errorMessages = document.querySelectorAll('.error-message');
    errorMessages.forEach(function(msg) {
        msg.textContent = '';
    });

    // Validate car image size
    var cover_image = document.getElementById('cover_image');
    var imageError = document.getElementById('cover_image_error');
    if (cover_image.files.length > 0) {
        var fileSize = cover_image.files[0].size / 1024 / 1024; // Convert size to MB
        if (fileSize > 2) {
            imageError.textContent = '*Image size must be less than or equal to 2MB.';
            return false;
        } else {
            imageError.textContent = '';
        }
    } else {
        imageError.textContent = '*Please upload a Property Image.';
        return false;
    }
    
    var property_type = document.getElementById('property_type').value;
    var property_type_error = document.getElementById('property_type_error');
    if (property_type === '') {
        property_type_error.textContent = '*Please select a Property Type.';
        return false;
    } else {
        property_type_error.textContent = '';
    }

    // Validate Property name
    var property_name = document.getElementById('name').value.trim();
    var property_name_error = document.getElementById('property_name_error');
    if (property_name === '') {
        property_name_error.textContent = '*property name is required.';
        return false;
    } else {
        property_name_error.textContent = '';
    }

    // Validate car price
    var email= document.getElementById('email').value.trim();
    var email_error = document.getElementById('email_error');
    if (email === '') {
        email_error.textContent = '*Email is required.';
        return false;
    } else {
        email_error.textContent = '';
    }

    // Validate Manager name
    var manager_name = document.getElementById('manager_name').value;
    var manager_name_error = document.getElementById('manager_name_error');
    if (manager_name === '') {
        manager_name_error.textContent = '*Please enter Manager name.';
        return false;
    } else {
        manager_name_error.textContent = '';
    }

    // Validate Phone No selection
    var phoneNo = document.getElementById('phoneNo').value;
    var phoneNo_error = document.getElementById('phoneNo_error');
    if (phoneNo === '') {
        phoneNo_error.textContent = '*Please enter Phone No';
        return false;
    } else {
        phoneNo_error.textContent = '';
    }

    // Validate street addess
    var street = document.getElementById('street').value;
    var street_address_error = document.getElementById('street_address_error');
    if (street === '') {
        street_address_error.textContent = '*Please enter address.';
        return false;
    } else {
        street_address_error.textContent = '';
    }
    // Validate city addess
    var city = document.getElementById('city').value;
    var city_error = document.getElementById('city_error');
    if (city === '') {
        city_error.textContent = '*Please enter property city..';
        return false;
    } else {
        city_error.textContent = '';
    }
   // Validate state
    var state = document.getElementById('state').value;
    var state_error = document.getElementById('state_error');
    if (state === '') {
        state_error.textContent = '*Please enter state.';
        return false;
    } else {
        state_error.textContent = '';
    }
    // Validate pin number
    var pin = document.getElementById('pin').value.trim();
    var pin_error = document.getElementById('pin_error');
    if (pin === '') {
        pin_error.textContent = '*Pin Number is required.';
        return false;
    } else {
        pin_error.textContent = '';
    }
  // Validate street addess
    var country = document.getElementById('country').value;
    var country_error = document.getElementById('country_error');
    if (country === '') {
        country_error.textContent = '*Please enter country.';
        return false;
    } else {
        country_error.textContent = '';
    }
    // Validate tour spot
    var tour_spot = document.getElementById('tour_spot').value;
    var tour_spot_error = document.getElementById('tour_spot_error');
    if (tour_spot === '') {
        tour_spot_error.textContent = '*Please enter Tour Spot.';
        return false;
    } else {
        tour_spot_error.textContent = '';
    }
    // Validate payment methods
    var payment = document.getElementById('payment').value;
    var payment_error = document.getElementById('payment_error');
    if (payment_methods === '') {
        payment_error.textContent = '*Please enter payment methods.';
        return false;
    } else {
        payment_error.textContent = '';
    }
    // Validate meta title
    var meta_title = document.getElementById('meta_title').value;
    var meta_title_error = document.getElementById('meta_title_error');
    if (meta_title === '') {
        meta_title_error.textContent = '*Please enter meta title.';
        return false;
    } else {
        meta_title_error.textContent = '';
    }
    // Validate checkIn time
    var checkIn = document.getElementById('checkIn').value;
    var checkIn_error = document.getElementById('checkIn_error');
    if (checkIn === '') {
        checkIn_error.textContent = '*Please enter checkIn time.';
        return false;
    } else {
        checkIn_error.textContent = '';
    }
    // Validate checkOut
    var checkOut = document.getElementById('checkOut').value;
    var checkOut_error = document.getElementById('checkOut_error');
    if (checkOut === '') {
        checkOut_error.textContent = '*Please enter checkOut Time.';
        return false;
    } else {
        checkOut_error.textContent = '';
    }
    // Validate tags
    var tags = document.getElementById('tags').value;
    var tags_error = document.getElementById('tags_error');
    if (tags === '') {
        tags_error.textContent = '*Please enter tags.';
        return false;
    } else {
        tags_error.textContent = '';
    }
    // If all validations pass, submit the form
    return true;
}
</script>
<?php
include('./resources/footer.php');

?>