<?php
include('resources/header.php');
include('admin/dashboard/config/dbcon.php');
// $package_fetch_query = mysqli_query($conn, "SELECT * FROM add_package WHERE status='1'");
$today = date('Y-m-d'); // Get today's date

$limit = 6; // Number of packages per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Count total records
$total_result = mysqli_query($conn, "
    SELECT COUNT(*) AS total FROM add_package 
    WHERE status = '1' 
      AND starting_from > '$today' 
      AND ending_at > '$today'
");
$total_row = mysqli_fetch_assoc($total_result);
$total_pages = ceil($total_row['total'] / $limit);

// Fetch paginated data
$package_fetch_query = mysqli_query($conn, "
    SELECT * FROM add_package 
    WHERE status = '1' 
      AND starting_from > '$today' 
      AND ending_at > '$today'
    LIMIT $limit OFFSET $offset
");
// echo " SELECT * FROM add_package 
//     WHERE status = '1' 
//       AND starting_from > '$today' 
//       AND ending_at > '$today'
//     LIMIT $limit OFFSET $offset";
?>

<!-- ===============  breadcrumb area start =============== -->
<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Tour Package</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Tour Package</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->

<div class="package-wrapper pt-80">
    <div class="container">
        <div class="row">
            <?php while ($package_display = mysqli_fetch_array($package_fetch_query)) {
                $imagePath = 'admin/dashboard/' . $package_display['package_image'];
                $defaultImage = 'assets/images/resort.jpg';
                if (empty($package_display['package_image']) || !file_exists($imagePath)) {
                    $imagePath = $defaultImage;
                }
            ?>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="package-card-alpha">
                        <div class="package-thumb">
                            <a href="<?php echo $imagePath; ?>" data-fancybox="gallery" data-caption="Caption Here" class="gallary-item-overlay">
                                <img src="<?php echo $imagePath; ?>" alt="Gallery Image" style="height: 200px;">
                            </a>
                            <p class="card-lavel">
                                <i class="bi bi-clock"></i> <span><?php echo $package_display['duration']; ?></span>
                            </p>
                        </div>
                        <div class="package-card-body">
                            <h3 class="p-card-title">
                                <a href="#"><?php echo $package_display['package_title']; ?></a>
                            </h3>
                            <p><?php echo $package_display['short_description']; ?></p>
                            <div class="p-card-bottom">
                                <div class="book-btn">
                                    <a href="package-details.php?id=<?php echo $package_display['package_id'] ?>">Book Now <i class='bx bxs-right-arrow-alt'></i></a>
                                </div>
                                <div class="p-card-info">
                                    <span>From</span>
                                    <h6>₹<?php echo $package_display['person_price']; ?><span> Per Person</span></h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <nav>
                    <ul class="pagination pagination-style-one justify-content-center pt-80">
                        <?php if ($page > 1): ?>
                            <li class="page-item page-arrow">
                                <a class="page-link" href="?page=<?= $page - 1 ?>"><i class="bi bi-chevron-double-left"></i></a>
                            </li>
                        <?php endif; ?>
        
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                                <a class="page-link" href="?page=<?= $i ?>"><?= str_pad($i, 2, "0", STR_PAD_LEFT) ?></a>
                            </li>
                        <?php endfor; ?>
        
                        <?php if ($page < $total_pages): ?>
                            <li class="page-item page-arrow">
                                <a class="page-link" href="?page=<?= $page + 1 ?>"><i class="bi bi-chevron-double-right"></i></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>

    </div>
</div>

<?php include('./resources/footer.php'); ?>
