<?php
include('../admin/dashboard/config/dbcon.php');
$contact_query=mysqli_query($conn,"SELECT * FROM contact_details LIMIT 1");
$contact_fetch=mysqli_fetch_assoc($contact_query);

$logo_query=mysqli_query($conn,"SELECT * FROM logos LIMIT 1");
$logo_fetch=mysqli_fetch_assoc($logo_query);

$inv=$_GET['id'] ?? '';
$verificationCode = isset($_GET['verify']) ? $_GET['verify'] : '';

$InvoiceQuery = "
SELECT * 
FROM invoices
WHERE invoice_number = '$inv'
";
$invoiceResult = mysqli_query($conn, $InvoiceQuery);

$bookings = [];

$packageBooking = null;
$propertyBooking = null;
$carBooking = null;

if ($invoiceRow = mysqli_fetch_assoc($invoiceResult)) {
    $bookingTypes = explode(',', $invoiceRow['booking_type']);
    $bookingIds = explode(',', $invoiceRow['booking_id']);
    $inv_date = date('d M Y', strtotime($invoiceRow['created_at']));
    $expectedVerificationCode = $invoiceRow['verification_code'];
    
    for ($i = 0; $i < count($bookingTypes); $i++) {
        $type = trim($bookingTypes[$i]);
        $id = trim($bookingIds[$i]);

        if ($type === 'package_bookings') {
            $query = "
            SELECT pb.*, ap.*, pb.full_name AS inv_name
            FROM package_bookings pb
            LEFT JOIN add_package ap ON ap.package_id = pb.package_id
            WHERE pb.id = $id
            ";

            $result = mysqli_query($conn, $query);
            if ($result && $row = mysqli_fetch_assoc($result)) {
                $packageBooking = $row;
            }
        } elseif ($type === 'property_bookings') {
            $query = "
            SELECT pb.*, ha.*, rd.*, pb.name AS inv_name
            FROM property_bookings pb
            LEFT JOIN Hotel_Add ha ON ha.hotel_id = pb.property_id
            LEFT JOIN room_details rd ON rd.roomId = pb.room_id
            WHERE pb.id = $id
            ";
            $result = mysqli_query($conn, $query);
            if ($result && $row = mysqli_fetch_assoc($result)) {
                $propertyBooking = $row;
            }
        } elseif ($type === 'car_bookings') {
            $query = "
            SELECT cb.*, acd.*, cb.full_name AS inv_name
            FROM car_bookings cb
            LEFT JOIN add_car_details acd ON acd.carId = cb.car_id
            WHERE cb.id = $id
            ";

            $result = mysqli_query($conn, $query);
            if ($result && $row = mysqli_fetch_assoc($result)) {
                $carBooking = $row;
            }
        }
    }
}
$grandTotal = 0;
$inv_name = 'unknown';

if (!empty($packageBooking) && isset($packageBooking['total_amount'])) {
    $grandTotal += (float)$packageBooking['total_amount'];
    $inv_name= $packageBooking['inv_name'];
    $inv_phone= $packageBooking['phone'];
}

if (!empty($propertyBooking) && isset($propertyBooking['total_amount'])) {
    $grandTotal += (float)$propertyBooking['total_amount'];
    $inv_name= $propertyBooking['inv_name'];
    $inv_phone= $propertyBooking['phone'];
}

if (!empty($carBooking) && isset($carBooking['total_amount'])) {
    $grandTotal += (float)$carBooking['total_amount'];
    $inv_name= $carBooking['inv_name'];
    $inv_phone= $carBooking['phone'];
}

if($invoiceRow['payment_type'] ==='advance'){
$paidAmount=$invoiceRow['advance_amount'];
}else{
 $paidAmount=$grandTotal;   
}
// Debug output (optional)
// echo "<h3>Package Booking</h3>";
// echo "<pre>"; print_r($packageBooking); echo "</pre>";

// echo "<h3>Property Booking</h3>";
// echo "<pre>"; print_r($propertyBooking); echo "</pre>";

// echo "<h3>Car Booking</h3>";
// echo "<pre>"; print_r($carBooking); echo "</pre>";

// $start = new DateTime($carBooking['starting_date']);
// $end = new DateTime($carBooking['ending_date']);
// $interval = $start->diff($end);
$carDays = 1;
?>
<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
  <!-- Meta Tags -->
  <meta charset="utf-8">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="author" content="BookingTrip.in">
  <link rel="icon" href="../admin/dashboard/<?php echo $logo_fetch['meta_logo']; ?>" type="image/png" sizes="32x32">
  <!-- Site Title -->
  <title>BookingTrip || Invoice</title>
  <link rel="stylesheet" href="assets/css/style.css">
</head>
<style>
    .tm_accent_bg, .tm_accent_bg_hover:hover {
        background-color: #ffffff;
    }
    .tm_accent_border {
        border-color: #caeff8;
    }
    .tm_gray_bg {
        background: #d1eef7;
    }
    .tm_border {
        border: 1px solid #3dbfe8;
    }
    .tm_accent_color, .tm_accent_color_hover:hover {
        color: #ea3f67;
    }
    .tm_container {
    padding: 10px;
    }
</style>
<body>
  <div class="tm_container">
    <div class="tm_invoice_wrap">
      <div class="tm_invoice tm_style2 tm_type1 tm_accent_border tm_radius_0" id="tm_download_section">
        <div class="tm_invoice_in">
          <div class="tm_invoice_head tm_mb20 tm_m0_md">
            <div class="tm_invoice_left">
              <div class="tm_logo"><img src="../admin/dashboard/<?php echo $logo_fetch['main_logo']; ?>" alt="Logo"></div>
            </div>
            <div class="tm_invoice_right">
              <div class="tm_grid_row tm_col_3">
                <div class="tm_text_center">
                  <p class="tm_accent_color tm_mb0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512" fill="currentColor"><path d="M424 80H88a56.06 56.06 0 00-56 56v240a56.06 56.06 0 0056 56h336a56.06 56.06 0 0056-56V136a56.06 56.06 0 00-56-56zm-14.18 92.63l-144 112a16 16 0 01-19.64 0l-144-112a16 16 0 1119.64-25.26L256 251.73l134.18-104.36a16 16 0 0119.64 25.26z"/></svg>
                  </p>
                  <?php echo $contact_fetch['email']?>
                </div>
                <div class="tm_text_center">
                  <p class="tm_accent_color tm_mb0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512" fill="currentColor"><path d="M391 480c-19.52 0-46.94-7.06-88-30-49.93-28-88.55-53.85-138.21-103.38C116.91 298.77 93.61 267.79 61 208.45c-36.84-67-30.56-102.12-23.54-117.13C45.82 73.38 58.16 62.65 74.11 52a176.3 176.3 0 0128.64-15.2c1-.43 1.93-.84 2.76-1.21 4.95-2.23 12.45-5.6 21.95-2 6.34 2.38 12 7.25 20.86 16 18.17 17.92 43 57.83 52.16 77.43 6.15 13.21 10.22 21.93 10.23 31.71 0 11.45-5.76 20.28-12.75 29.81-1.31 1.79-2.61 3.5-3.87 5.16-7.61 10-9.28 12.89-8.18 18.05 2.23 10.37 18.86 41.24 46.19 68.51s57.31 42.85 67.72 45.07c5.38 1.15 8.33-.59 18.65-8.47 1.48-1.13 3-2.3 4.59-3.47 10.66-7.93 19.08-13.54 30.26-13.54h.06c9.73 0 18.06 4.22 31.86 11.18 18 9.08 59.11 33.59 77.14 51.78 8.77 8.84 13.66 14.48 16.05 20.81 3.6 9.53.21 17-2 22-.37.83-.78 1.74-1.21 2.75a176.49 176.49 0 01-15.29 28.58c-10.63 15.9-21.4 28.21-39.38 36.58A67.42 67.42 0 01391 480z"/></svg>
                  </p>
                  <?php echo $contact_fetch['phoneNo']?>
                </div>
                <div class="tm_text_center">
                  <p class="tm_accent_color tm_mb0">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512" fill="currentColor"><circle cx="256" cy="192" r="32"/><path d="M256 32c-88.22 0-160 68.65-160 153 0 40.17 18.31 93.59 54.42 158.78 29 52.34 62.55 99.67 80 123.22a31.75 31.75 0 0051.22 0c17.42-23.55 51-70.88 80-123.22C397.69 278.61 416 225.19 416 185c0-84.35-71.78-153-160-153zm0 224a64 64 0 1164-64 64.07 64.07 0 01-64 64z"/></svg>
                  </p>
                  <?php echo $contact_fetch['address']; ?>
                </div>
              </div>
            </div>
            <div class="tm_shape_bg tm_accent_bg"></div>
          </div>
          
          <div class="tm_invoice_info tm_mb30 tm_align_center">
            <div class="tm_invoice_info_left tm_mb20_md">
              <p class="tm_mb0">
                <b class="tm_primary_color">Invoice No: </b>#<?php echo $inv ?> <br>
                <b class="tm_primary_color">Invoice Date: </b><?php echo $inv_date ?><br>
                <b class="tm_primary_color">Invoice To: </b> <?php echo $inv_name ?><br>
                <b class="tm_primary_color">Phone: </b> <?php echo $inv_phone ?>
              </p>
            </div>
            <div class="tm_invoice_info_right">
              <!-- <div class="tm_f50 tm_text_uppercase tm_text_center tm_invoice_title tm_mb15 tm_ternary_color">Invoice</div> -->
              <div class="tm_border tm_radius_0 tm_gray_bg tm_curve_35 tm_text_center">
                <div>
                  <b class="tm_accent_color tm_f26 tm_medium tm_body_lineheight">Total: ₹<?php echo number_format($grandTotal, 2)?></b>
                </div>
              </div>
            </div>
          </div>
          <!--<div class="tm_invoice_head tm_mb10">-->
          <!--  <div class="tm_invoice_left">-->
          <!--    <p class="tm_mb2"><b class="tm_primary_color">Invoice To:</b></p>-->
          <!--    <p>-->
          <!--      Lowell H. Dominguez <br>-->
          <!--      84 Spilman Street, London <br>United Kingdom <br>-->
          <!--      lowell@gmail.com-->
          <!--    </p>-->
          <!--  </div>-->
          <!--  <div class="tm_invoice_right tm_text_right">-->
          <!--    <p class="tm_mb2"><b class="tm_primary_color">Pay To:</b></p>-->
          <!--    <p>-->
          <!--      Laralink Ltd <br>-->
          <!--      86-90 Paul Street, London<br>-->
          <!--      England EC2A 4NE <br>-->
          <!--      demo@gmail.com-->
          <!--    </p>-->
          <!--  </div>-->
          <!--</div>-->
          <?php if (!empty($carBooking)) : ?>
          <div class="tm_grid_row tm_col_4 tm_col_2_md tm_invoice_info_in tm_round_border tm_mb30 tm_radius_0">
            <div>
              <span>Car & Model:</span> <br>
              <b class="tm_primary_color tm_medium"><?php echo $carBooking['car_name'] ?></b>
            </div>
            <div>
              <span>Car Type:</span> <br>
              <b class="tm_primary_color tm_medium"><?php echo $carBooking['maxSeat'] ?> sit Economy</b>
            </div>
            <div>
              <span>Rental Date:</span> <br>
              <b class="tm_primary_color tm_medium"><?php echo $carBooking['starting_date'] ?></b>
            </div>
            <div>
              <span>Sightseeing:</span> <br>
              <b class="tm_primary_color tm_medium"><?php if($carBooking['visit_site_scene']=='on') {echo 'Yes'; }else{ echo 'No';}?></b>
            </div>
          </div>
          <?php endif; ?>
          
          <?php if (!empty($propertyBooking)) : ?>
          <h2 class="tm_f16 tm_section_heading tm_border_color tm_mb0"><span class="tm_gray_bg tm_radius_0 tm_curve_35 tm_border tm_border_bottom_0"><span>Property Overview</span></span></h2>
          <div class="tm_table tm_style1 tm_mb30">
            <div class="tm_border tm_border_top_0">
              <div class="tm_table_responsive">
                <table>
                  <tbody>
                    <tr>
                      <td class="tm_width_6 tm_border_top_0">
                        <b class="tm_primary_color tm_medium">Property Name: </b><?php echo $propertyBooking['name']?>
                      </td>
                      <td class="tm_width_6 tm_border_top_0 tm_border_left">
                        <b class="tm_primary_color tm_medium">Property Type: </b><?php echo $propertyBooking['property_Type']?>
                      </td>
                    </tr>
                    <tr>
                      <td class="tm_width_6">
                        <b class="tm_primary_color tm_medium">Room Type: </b><?php echo $propertyBooking['room_name']?>
                      </td>
                      <td class="tm_width_6 tm_border_left">
                        <b class="tm_primary_color tm_medium">Address: </b><?php echo $propertyBooking['street']?>, <?php echo $propertyBooking['city']?>, <?php echo $propertyBooking['state']?>, <?php echo $propertyBooking['pin']?>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <?php endif; ?>
          
          <div class="tm_table tm_style1">
            <div class="tm_border">
              <div class="tm_table_responsive">
                <table>
                  <thead>
                    <tr>
                      <th class="tm_width_8 tm_semi_bold tm_primary_color">Rate Sheet</th>
                      <th class="tm_width_3 tm_semi_bold tm_primary_color">Rate</th>
                      <th class="tm_width_2 tm_semi_bold tm_primary_color tm_text_right">Total</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if (!empty($packageBooking)) : ?>
                    <tr>
                      <td class="tm_width_8"><?php echo $packageBooking['package_title']?>,<br>Duration: <?php echo $packageBooking['duration']?><br>Journey Date : <?php echo $packageBooking['starting_from']?> to <?php echo $packageBooking['ending_at']?></td>
                      <td class="tm_width_3"><?php echo $packageBooking['adults']?> adult + <?php echo $packageBooking['children']?> children</td>
                      <td class="tm_width_2 tm_text_right">₹<?php echo number_format($grandTotal, 2)?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if (!empty($propertyBooking)) : ?>
                    <tr>
                        <?php
                        $checkInDate = date('d M Y', strtotime($propertyBooking['check_in']));
                        $checkInTime = date('h:i A', strtotime($propertyBooking['checkIn']));
                        
                        $checkOutDate = date('d M Y', strtotime($propertyBooking['check_out']));
                        $checkOutTime = date('h:i A', strtotime($propertyBooking['checkOut']));
                        
                        $checkIn = new DateTime($propertyBooking['check_in']);
                        $checkOut = new DateTime($propertyBooking['check_out']);
                        $interval = $checkIn->diff($checkOut);
                        $numDays = $interval->days > 0 ? $interval->days : 1;
                        ?>
                      <td class="tm_width_8">
                            <?php echo $propertyBooking['room_name']?> Room, Max-Occupancy: <?php echo $propertyBooking['occupancy']?> people<br>
                            Check-In: <?php echo "$checkInDate at $checkInTime"; ?><br>
                            Check-Out: <?php echo "$checkOutDate at $checkOutTime"; ?><br>
                            Discount: <?php echo $propertyBooking['discount']; ?>%
                      </td>
                      <td class="tm_width_3"> <?php echo $numDays?> days x <?php echo $propertyBooking['number_of_rooms']?> room</td>
                      <td class="tm_width_2 tm_text_right">₹<?php echo $propertyBooking['total_amount']?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if (!empty($carBooking)) : ?>
                    <tr>
                      <td class="tm_width_8"><?php echo $carBooking['car_name'] ?><?php if($carBooking['visit_site_scene']='on') { ?><br>Sightseeing details :<?php echo $carBooking['site_scene_details']; }?></td>
                      <td class="tm_width_3"><?php echo $carDays ?> days</td>
                      <td class="tm_width_2 tm_text_right">₹ <?php echo $carBooking['total_amount'] ?></td>
                    </tr>
                    <?php endif; ?>
                  </tbody>
                </table>
              </div>
            </div>
            <div class="tm_invoice_footer tm_mb15 tm_m0_md">
              <div class="tm_left_footer">
                    <?php
                    if ($verificationCode === $expectedVerificationCode) {
                    ?>
                    <img src="https://png.pngtree.com/png-clipart/20230804/original/pngtree-vector-authentic-stamp-icon-element-ink-stamp-vector-picture-image_9539999.png" style="height: 100px;">
                    <?php
                    }
                    ?>
                <!--<p class="tm_mb2"><b class="tm_primary_color">Payment info:</b></p>-->
                <!--<p class="tm_m0">Jhon Doe <br>Credit Card - 236***********928 <br>Amount: $315</p>-->
              </div>
              <div class="tm_right_footer">
                <table class="tm_mb15 tm_m0_md">
                  <tbody>
                    <tr>
                      <td class="tm_width_3 tm_primary_color tm_border_none tm_medium">Subtoal</td>
                      <td class="tm_width_3 tm_primary_color tm_text_right tm_border_none tm_medium">₹<?php echo number_format($grandTotal, 2)?></td>
                    </tr>
                    <!--<tr>-->
                    <!--  <td class="tm_width_3 tm_danger_color tm_border_none tm_pt0">Discount 10%</td>-->
                    <!--  <td class="tm_width_3 tm_danger_color tm_text_right tm_border_none tm_pt0">-$35</td>-->
                    <!--</tr>-->
                    <tr>
                      <td class="tm_width_3 tm_primary_color tm_border_none tm_pt0">Tax 0%</td>
                      <td class="tm_width_3 tm_primary_color tm_text_right tm_border_none tm_pt0">+₹0</td>
                    </tr>
                    <tr style="border-top: 2px solid;  border-bottom: 2px solid;">
                      <td class="tm_width_3 tm_border_top_0 tm_bold tm_f16 tm_accent_bg" style="color: #7c7676;">Grand Total	</td>
                      <td class="tm_width_3 tm_border_top_0 tm_bold tm_f16 tm_primary_color tm_text_right tm_accent_bg" style="color: #7c7676;">₹<?php echo number_format($grandTotal, 2)?></td>
                    </tr>
                    <tr style="border-bottom: 2px solid;">
                        <td class="tm_width_3 tm_border_none tm_medium" style="color: #4CAF50;">Paid Amount</td>
                        <td class="tm_width_3 tm_text_right tm_border_none tm_medium" style="color: #4CAF50;">₹<?php echo number_format($paidAmount, 2) ?></td>
                      </tr>
                      <tr style="border-bottom: 2px solid;">
                        <td class="tm_width_3 tm_border_none tm_medium" style="color: #F44336;">Due Amount</td>
                        <td class="tm_width_3 tm_text_right tm_border_none tm_medium" style="color: #F44336;">₹<?php echo number_format($grandTotal - $paidAmount, 2) ?></td>
                      </tr>
                  </tbody>
                </table>
              </div>
            </div>
            <div class="tm_invoice_footer tm_type1">
              <div class="tm_left_footer"></div>
              <div class="tm_right_footer">
                <div class="tm_sign tm_text_center">
                  <img src="assets/img/sign.svg" alt="Sign">
                  <p class="tm_m0 tm_ternary_color">Jhon Donate</p>
                  <p class="tm_m0 tm_f16 tm_primary_color">Accounts Manager</p>
                </div>
              </div>
            </div>
          </div>
          <div class="tm_bottom_invoice">
            <div class="tm_bottom_invoice_left">
              <p class="tm_m0 tm_f18 tm_accent_color tm_mb5">Thank you for your business.</p>
              <!--<p class="tm_primary_color tm_f12 tm_m0 tm_bold">Terms & Condition</p>-->
              <!--<p class="tm_m0 tm_f12">Invoice was created on a computer.</p>-->
            </div>
            <div class="tm_bottom_invoice_right tm_mobile_hide">
              <div class="tm_logo"><img src="../admin/dashboard/<?php echo $logo_fetch['meta_logo']; ?>" alt="Logo"></div>
            </div>
          </div>
        </div>
      </div>
      <div class="tm_invoice_btns tm_hide_print">
        <a href="javascript:window.print()" class="tm_invoice_btn tm_color1">
          <span class="tm_btn_icon">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path d="M384 368h24a40.12 40.12 0 0040-40V168a40.12 40.12 0 00-40-40H104a40.12 40.12 0 00-40 40v160a40.12 40.12 0 0040 40h24" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"/><rect x="128" y="240" width="256" height="208" rx="24.32" ry="24.32" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"/><path d="M384 128v-24a40.12 40.12 0 00-40-40H168a40.12 40.12 0 00-40 40v24" fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="32"/><circle cx="392" cy="184" r="24" fill='currentColor'/></svg>
          </span>
          <span class="tm_btn_text">Print</span>
        </a>
        <button id="tm_download_btn" class="tm_invoice_btn tm_color2">
          <span class="tm_btn_icon">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><path d="M320 336h76c55 0 100-21.21 100-75.6s-53-73.47-96-75.6C391.11 99.74 329 48 256 48c-69 0-113.44 45.79-128 91.2-60 5.7-112 35.88-112 98.4S70 336 136 336h56M192 400.1l64 63.9 64-63.9M256 224v224.03" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/></svg>
          </span>
          <span class="tm_btn_text">Download</span>
        </button>
      </div>
    </div>
  </div>
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/js/jspdf.min.js"></script>
  <script src="assets/js/html2canvas.min.js"></script>
  <script src="assets/js/main.js"></script>
</body>
</html>