<?php include('resources/header.php');
session_start();
?>
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // echo '<pre>';
    // print_r($_POST);
    // echo '</pre>';
    $total = 0;
    $totalAmount = 0;
    $invoice_total = 0;
    $daily_price = 0;
    
    // -------------------------------
    // Handle Hotel Booking Data
    // -------------------------------
    if (!empty($_POST['hotel_booking_data'])) {

        $hotel_booking_data = json_decode($_POST['hotel_booking_data'], true);
        $property_id = $hotel_booking_data['property_id'];
        $name = $hotel_booking_data['name'];
        $fullName = $hotel_booking_data['name'];
        $email = $hotel_booking_data['email'];
        $phone = $hotel_booking_data['phone'];
        $adults = $hotel_booking_data['adults'];
        $room_id = $hotel_booking_data['room_id'];
        $number_of_rooms = $hotel_booking_data['number_of_rooms'];
        $fromDate = $hotel_booking_data['fromDate'];
        $toDate = $hotel_booking_data['toDate'];
        $message = $hotel_booking_data['message'];
        $total = $hotel_booking_data['total'];
        
        $start = new DateTime($fromDate);
        $end = new DateTime($toDate);
        $Hdiff = $start->diff($end)->days;
        
        $number_of_days = $Hdiff > 0 ? $Hdiff : 1; // fallback to 1 if same day or error

    }

    // -------------------------------
    // Handle Car Booking Data
    // -------------------------------
    if (!empty($_POST['carId'])) {
        $_SESSION['car_booking'] = $_POST;
        
        $carId = $_POST['carId'];
        $price = $_POST['price'];
        $scenePrice = $_POST['scenePrice'];
        $fullName = $_POST['full_name'];
        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $starting_date = $_POST['starting_date'];
        $formatted_start_date = date('Y-m-d', strtotime(str_replace('-', '/', $starting_date)));
        // $ending_date = $_POST['ending_date'];
        // $formatted_end_date = date('Y-m-d', strtotime(str_replace('-', '/', $ending_date)));
        $spotA = $_POST['spotA'];
        $spotB = $_POST['spotB'];
        $message_car = $_POST['message'];
        $daily_price = $_POST['total_amount'];
        $visit_site_scene=$_POST['visit-site-scene'];
        $site_scene=$_POST['site_scene_details'];
        
        // $start = new DateTime($formatted_start_date);
        // $end = new DateTime($formatted_end_date);
        // $diff = $start->diff($end)->days + 1; // +1 to include same day as 1 day
        
        // $total_days = $diff > 0 ? $diff : 1; // Fallback to 1 in case of weird logic
        $totalAmount = $daily_price;
    }
    // -------------------------------
    // Final Total Calculation
    // -------------------------------
    $invoice_total=$totalAmount+$total;

} else {
    echo "Invalid request method!";
}

$car_sql=mysqli_query($conn,"SELECT add_car_details.*, spotA_table.spot AS spotA_name, spotB_table.spot AS spotB_name FROM add_car_details LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId WHERE carId='$carId'");
$car_fetch=mysqli_fetch_assoc($car_sql);

$resort_fetch_query=mysqli_query($conn,"SELECT * FROM Hotel_Add WHERE hotel_id = $property_id");
$property = mysqli_fetch_assoc($resort_fetch_query);

$room_fetch_query=mysqli_query($conn,"SELECT * FROM room_details WHERE roomId = $room_id");
$room = mysqli_fetch_assoc($room_fetch_query);
?>
<style>
    .text-primary {
    color: #eb5744 !important;
}
</style>
<!-- ===============  breadcrumb area start =============== -->
<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Checkout</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Checkout</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->

<div class="package-details-wrapper pt-76">
    <div class="container">
        <div class="row">
            <!-- LEFT COLUMN -->
            <div class="col-lg-6 mb-4">
                <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-20">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Your Booking Details</h4>
                             <h3 class="widget-lavel"><span>Total Amount:</span> ₹<?php echo $invoice_total?></h3>
                        </div>

                        <div class="widget-body mb-4 mb-sm-4">
                            <form>
                                <div class="booking-form-wrapper">
                                    <?php
                                    if (!empty($_POST['hotel_booking_data'])) {
                                    ?>
                                    <!-- Hotel Info -->
                                    <div class="mb-4 p-3 rounded bg-light border">
                                        <h5 class="text-primary mb-2"><?php echo $property['name']; ?></h5>
                                        <p class="mb-1"><strong> Location:</strong> <?php echo $property['city']; ?>, <?php echo $property['state']; ?>, <?php echo $property['country']; ?></p>
                                        <p class="mb-1"><strong> Check-in:</strong> <span class="text-dark"><?php echo $fromDate; ?>, <?php echo $property['checkIn']; ?></span></p>
                                        <p class="mb-0"><strong> Check-out:</strong> <span class="text-dark"><?php echo $toDate; ?>, <?php echo $property['checkOut']; ?></span></p>
                                    </div>
                                    
                                    <!-- Room Info -->
                                    <div class="mb-4 p-3 rounded bg-white border">
                                        <h6 class="text-dark mb-2">Room Info</h6>
                                        <p class="mb-1"><strong>Type:</strong> <?php echo $room['room_name']; ?></p>
                                        <p class="mb-1"><strong>Price/Night:</strong> <span class="badge bg-success text-white">₹<?php echo $room['price_per_night']; ?></span></p>
                                        <p class="mb-0"><strong>No. of Rooms:</strong> <?php echo $number_of_rooms; ?> rooms for <?php echo $number_of_days; ?> days</p>
                                        <p class="mb-1"><strong>Total Price:</strong> <span class="badge bg-success text-white">₹<?php echo $total; ?></span></p>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <?php
                                    if (!empty($_POST['carId'])) {
                                    ?>
                                    <!-- Car Info -->
                                    <div class="mb-4 p-3 rounded bg-light border">
                                        <h6 class="text-dark mb-2"><span class="badge bg-warning text-dark"> Car - ₹<?php echo $car_fetch['price']; ?></span></h6>
                                        <p class="mb-1"><strong>Car:</strong> <?php echo $car_fetch['car_name']; ?></p>
                                        <p class="mb-1"><strong>From:</strong> <?php echo $spotA; ?></p>
                                        <p class="mb-1"><strong>To:</strong> <?php echo $spotB; ?></p>
                                        <p class="mb-1"><strong>Rental Date:</strong> <?php echo $formatted_start_date; ?></p>
                                        <p class="mb-1"><strong>Max Seats:</strong> <?php echo $car_fetch['maxSeat']; ?></p>
                                        <?php
                                        if($visit_site_scene=='on'){
                                        ?>
                                        <p class="mb-1"><span class="badge bg-warning text-dark">Sightseeing: - ₹<?php echo $car_fetch['scenePrice']; ?></span></p>
                                        <p class="mb-1"><strong>Sightseeing Places:</strong> <?php echo $site_scene; ?></p>
                                        <?php } ?>
                                        <p class="mb-0"><strong>Total Price:</strong> <span class="badge bg-warning text-dark">₹<?php echo $totalAmount; ?></span></p>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    <!-- Total -->
                                    <hr class="my-3">
                                    <div class="text-center">
                                        <h5 class="text-success fw-bold">Total Amount: ₹<?php echo $invoice_total?></h5>
                                    </div>


                                </div>
                            </form>
                        </div>
                    </aside>
                </div>
            </div>

            <!-- RIGHT COLUMN -->
            <div class="col-lg-6">
                <div class="package-sidebar">
                    <aside class="package-widget-style-2 widget-form mt-20">
                        <div class="widget-title text-center d-flex justify-content-between">
                            <h4>Confirm Booking</h4>
                        </div>

                        <div class="widget-body mb-4 mb-sm-4">
                            <form id="bookingForm">
                                <div class="booking-form-wrapper">
                                    <div class="custom-input-group">
                                        <input type="text" placeholder="Your Full Name" name="f_name" required value="<?php echo $fullName; ?>">
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="email" placeholder="Your Email" name="f_email" required value="<?php echo $email; ?>">
                                    </div>
                                    <div class="custom-input-group">
                                        <input type="tel" placeholder="Phone" name="f_ph" required value="<?php echo $phone; ?>">
                                    </div>

                                    <div class="custom-input-group">
                                        <textarea cols="20" rows="7" name="message" placeholder="Your message"></textarea>
                                    </div>
                                    <div class="custom-input-group">
                                        <label for="payment_type"><strong>Payment Type</strong></label>
                                        <select id="payment_type" name="payment_type" required>
                                            <option value="">Select Payment Type</option>
                                            <option value="full">Full Payment</option>
                                            <option value="advance">Advance Payment</option>
                                        </select>
                                    </div>
                                    
                                    <div class="custom-input-group" id="advance_amount_group" style="display:none;">
                                        <label for="advance_amount"><strong>Advance Amount</strong></label>
                                        <input type="number" id="advance_amount" name="advance_amount" min="0" placeholder="Enter Advance Amount">
                                        <div id="booking_error" class="text-danger mt-2" style="display: none;"></div>
                                        <small class="text-muted">Minimum 30% of ₹<?php echo $invoice_total; ?> = ₹<?php echo round($invoice_total * 0.3); ?></small>
                                    </div>


                                    <div class="custom-input-group">
                                        <div class="submite-btn">
                                            <button type="submit">Next</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('resources/footer.php'); ?>
<script>
    const bookingPostData = <?php echo json_encode($_POST); ?>;
    console.log(bookingPostData);
    const invoiceTotal = <?php echo $invoice_total; ?>;
    const minAdvance = Math.ceil(invoiceTotal * 0.3);
    const errorDiv = $('#booking_error');
    
    $('#payment_type').on('change', function () {
        const selected = $(this).val();
        errorDiv.hide().text('');
        
        if (this.value === 'advance') {
            $('#advance_amount_group').show();
            $('#advance_amount').prop('required', true);
        } else {
            $('#advance_amount_group').hide();
            $('#advance_amount').prop('required', false).val('');
        }
    });
$('#bookingForm').on('submit', function (e) {
    e.preventDefault();
    const paymentType = $('#payment_type').val();
    const advanceAmount = parseFloat($('#advance_amount').val());
    errorDiv.hide().text('');
    // Validate minimum 30% if advance selected
    if (paymentType === 'advance') {
        if (isNaN(advanceAmount) || advanceAmount < minAdvance) {
            errorDiv.text('Advance amount must be at least ₹' + minAdvance).show();
            return false;
        }
    }
    const formData = new FormData(this);

    // Dynamically append POST data
    for (const key in bookingPostData) {
        if (bookingPostData.hasOwnProperty(key)) {
            console.log(`Appending: ${key} = ${bookingPostData[key]}`);
            formData.append(key, bookingPostData[key]);
        }
    }

    // Optional: Full view of FormData
    console.log("Final FormData:");
    for (let pair of formData.entries()) {
        console.log(`${pair[0]}: ${pair[1]}`);
    }

    $.ajax({
        url: 'submit-booking.php',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            // Parse the JSON response from PHP
            var data = JSON.parse(response);
    
            if (data.status === 'success') {
                // Store the invoice number in localStorage or sessionStorage to use on the thank-you page
                localStorage.setItem('invoice_number', data.invoice_number);
                // Redirect to the thank-you page
                window.location.href = 'thank-you.php';
            } else {
                console.error('Error:', data.message);
                alert('Booking failed! Please try again.');
            }
        },
        error: function (xhr, status, error) {
            console.error('Booking failed:', error);
            alert('Booking failed! Please try again.');
            window.location.href = 'all-booking.php?Booking failed!';
        }
    });
});


</script>
