<?php
include('resources/header.php');

$whereClauses = ["status='1'"]; // Default condition
$params = []; // For holding filter values


if (!empty($_GET['spot'])) {
    $spot = mysqli_real_escape_string($conn, $_GET['spot']);
    $whereClauses[] = "(spotA_table.spotId = '$spot' OR spotB_table.spotId = '$spot')";
}

if (!empty($_GET['pickup'])) {
    $pickup = mysqli_real_escape_string($conn, $_GET['pickup']);
    $whereClauses[] = "spotA_table.spot LIKE '%$pickup%'";
}

if (!empty($_GET['drop'])) {
    $drop = mysqli_real_escape_string($conn, $_GET['drop']);
    $whereClauses[] = "spotB_table.spot LIKE '%$drop%'";
}


if (!empty($_GET['minSeat'])) {
    $minSeat = (int)$_GET['minSeat'];
    $whereClauses[] = "add_car_details.maxSeat >= $minSeat";
}

if (!empty($_GET['car_name'])) {
    $carName = mysqli_real_escape_string($conn, $_GET['car_name']);
    $whereClauses[] = "add_car_details.car_name LIKE '%$carName%'";
}

// Build final SQL with filters
$whereSQL = implode(" AND ", $whereClauses);


$results_per_page = 9; 
$current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start_from = ($current_page - 1) * $results_per_page;
$count_query = "
    SELECT COUNT(*) as total 
    FROM add_car_details 
    LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId 
    LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId 
    WHERE $whereSQL
";

$count_result = mysqli_query($conn, $count_query);
$total_records = mysqli_fetch_assoc($count_result)['total'];
$total_pages = ceil($total_records / $results_per_page);


$spot_fetch = mysqli_query($conn, "
    SELECT add_car_details.*, 
           spotA_table.spot AS spotA_name, 
           spotB_table.spot AS spotB_name 
    FROM add_car_details 
    LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId 
    LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId 
    WHERE $whereSQL
    LIMIT $start_from, $results_per_page
");
// $s="SELECT add_car_details.*, 
//           spotA_table.spot AS spotA_name, 
//           spotB_table.spot AS spotB_name 
//     FROM add_car_details 
//     LEFT JOIN spots AS spotA_table ON add_car_details.spotA = spotA_table.spotId 
//     LEFT JOIN spots AS spotB_table ON add_car_details.spotB = spotB_table.spotId 
//     WHERE $whereSQL";
?>

<?php
$spots = [];
$joining_query = mysqli_query($conn, "SELECT tours.state AS state_name, spots.* FROM spots JOIN tours ON tours.id = spots.tour_id");
while ($row = mysqli_fetch_assoc($joining_query)) {
    $spots[] = [
        'spotId' => $row['spotId'],
        'spot' => $row['spot'],
        'state' => $row['state_name']
    ];
}
?>
<style>
.page-item.active .page-link {
    background-color: #ff4838;
    border-color: #dc3545;
}
.page-link {
    color: #dc3545;
}

</style>
<!-- ===============  breadcrumb area start =============== -->
<div class="breadcrumb breadcrumb-style-one">
    <div class="container">
        <div class="col-lg-12 text-center">
            <h2 class="breadcrumb-title">Cars</h2>
            <ul class="d-flex justify-content-center breadcrumb-items">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active">Car Lists</li>
            </ul>
        </div>
    </div>
</div>
<!-- ===============  breadcrumb area end =============== -->

<div class="package-wrapper pt-80">
    <div class="container">
        <form method="GET" class="mb-5">
          <div class="bg-light p-4 rounded shadow-sm">
            <div class="d-flex flex-wrap align-items-end gap-3">
              
              <div class="flex-grow-1">
                <select  class="form-select form-control-modern" name="state" id="stateSelect" >
                    <option value="">Choose State</option>
                    <option value="Andaman and Nicobar Islands">Andaman and Nicobar Islands</option>
                    <option value="Andhra Pradesh">Andhra Pradesh</option>
                    <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                    <option value="Assam">Assam</option>
                    <option value="Bihar">Bihar</option>
                    <option value="Chandigarh">Chandigarh</option>
                    <option value="Chhattisgarh">Chhattisgarh</option>
                    <option value="Dadra and Nagar Haveli and Daman and Diu">Dadra and Nagar Haveli and Daman and Diu</option>
                    <option value="Delhi">Delhi</option>
                    <option value="Goa">Goa</option>
                    <option value="Gujarat">Gujarat</option>
                    <option value="Haryana">Haryana</option>
                    <option value="Himachal Pradesh">Himachal Pradesh</option>
                    <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                    <option value="Jharkhand">Jharkhand</option>
                    <option value="Karnataka">Karnataka</option>
                    <option value="Kerala">Kerala</option>
                    <option value="Ladakh">Ladakh</option>
                    <option value="Lakshadweep">Lakshadweep</option>
                    <option value="Madhya Pradesh">Madhya Pradesh</option>
                    <option value="Maharashtra">Maharashtra</option>
                    <option value="Manipur">Manipur</option>
                    <option value="Meghalaya">Meghalaya</option>
                    <option value="Mizoram">Mizoram</option>
                    <option value="Nagaland">Nagaland</option>
                    <option value="Odisha">Odisha</option>
                    <option value="Puducherry">Puducherry</option>
                    <option value="Punjab">Punjab</option>
                    <option value="Rajasthan">Rajasthan</option>
                    <option value="Sikkim">Sikkim</option>
                    <option value="Tamil Nadu">Tamil Nadu</option>
                    <option value="Telangana">Telangana</option>
                    <option value="Tripura">Tripura</option>
                    <option value="Uttar Pradesh">Uttar Pradesh</option>
                    <option value="Uttarakhand">Uttarakhand</option>
                    <option value="West Bengal">West Bengal</option>
                  </select>
              </div>

              <div class="flex-grow-1">
                <select  class="form-select form-control-modern" id="spotSelect" name="spot">
                    <option value="">Choose Spot</option>
                </select>
                
              </div>
        
              <div class="flex-grow-1">
                <input type="text" class="form-control form-control-modern" name="pickup" placeholder="Pickup Location">
              </div>
        
              <div class="flex-grow-1">
                <input type="text" class="form-control form-control-modern" name="drop" placeholder="Drop Location">
              </div>
        
              <div class="flex-grow-1">
                <input type="number" class="form-control form-control-modern" name="minSeat" placeholder="Minimum Seat" min="1">
              </div>
        
              <div class="flex-grow-1">
                <input type="text" class="form-control form-control-modern" name="car_name" placeholder="Car Name">
              </div>
        
              <div>
                <button type="submit" class="btn btn-danger rounded-pill px-4">
                  <i class="bi bi-search"></i>
                </button>
              </div>
        
            </div>
          </div>
        </form>


        <div class="row">
            <?php while ($car_display = mysqli_fetch_array($spot_fetch)) { 
                $carImgPath = 'admin/dashboard/' . $car_display['car_img'];
                $fallbackImg = 'assets/images/resort.jpg';
                if (empty($car_display['car_img']) || !file_exists($carImgPath)) {
                    $carImgPath = $fallbackImg;
                }
            ?>
                <div class="col-lg-4 mb-4">
                    <div class="package-card-alpha">
                        <div class="package-thumb">
                            <a href="<?php echo $carImgPath; ?>" data-fancybox="gallery" data-caption="Caption Here" class="gallary-item-overlay">
                                <img src="<?php echo $carImgPath; ?>" alt="Gallery Image" style="height: 200px;">
                            </a>
                            <p class="card-lavel">
                                <i class="fa-solid fa-person"></i>
                                <span>MaxSeat <?php echo $car_display['maxSeat'] ?></span>
                            </p>
                        </div>

                        <div class="package-card-body">
                            <h3 class="p-card-title"><?php echo $car_display['car_name'] ?></h3>
                            <h5><?php echo $car_display['spotA_name'] ?> to <?php echo $car_display['spotB_name'] ?></h5>
                            <div class="p-card-bottom">
                                <div class="book-btn">
                                    <a href="car-details.php?id=<?php echo $car_display['carId'] ?>">Book Now <i class='bx bxs-right-arrow-alt'></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
    <?php if ($total_pages > 1): ?>
    <nav class="d-flex justify-content-center mb-4">
        <ul class="pagination pagination-rounded">

            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                <?php
                    $queryParams = $_GET;
                    $queryParams['page'] = $i;
                    $pageUrl = '?' . http_build_query($queryParams);
                ?>
                <li class="page-item <?php if ($i == $current_page) echo 'active'; ?>">
                    <a class="page-link" href="<?php echo $pageUrl; ?>"><?php echo $i; ?></a>
                </li>
            <?php endfor; ?>

        </ul>
    </nav>
<?php endif; ?>

</div>

<?php include('./resources/footer.php'); ?>
<script>
    // PHP array to JavaScript
    const spots = <?php echo json_encode($spots); ?>;

    const stateSelect = document.getElementById('stateSelect');
    const spotSelect = document.getElementById('spotSelect');

    stateSelect.addEventListener('change', function() {
        const selectedState = this.value;
        spotSelect.innerHTML = '<option value="">Choose Spot</option>'; // Reset options

        // Filter spots based on selected state
        const filteredSpots = spots.filter(spot => spot.state === selectedState);

        // Populate spot dropdown
        filteredSpots.forEach(spot => {
            const option = document.createElement('option');
            option.value = spot.spotId;
            option.textContent = spot.spot;
            spotSelect.appendChild(option);
        });
    });
</script>
