<?php
include('./config/dbcon.php');
include('./resources/header.php');
// Assuming $conn is your database connection
$packageBookings = mysqli_query($conn, "
     SELECT pb.*, i.invoice_number ,i.created_at,i.payment_type,i.advance_amount
        FROM package_bookings pb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('package_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(pb.id, i.booking_id) > 0
        ORDER BY pb.id DESC
");
$propertyBookings = mysqli_query($conn, "
    SELECT pb.*, i.invoice_number ,i.created_at,i.payment_type,i.advance_amount
        FROM property_bookings pb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('property_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(pb.id, i.booking_id) > 0
        ORDER BY pb.id DESC
");

$carBookings = mysqli_query($conn, "
    SELECT cb.*, i.invoice_number ,i.created_at,i.payment_type,i.advance_amount
        FROM car_bookings cb 
        LEFT JOIN invoices i 
            ON FIND_IN_SET('car_bookings', i.booking_type) > 0 
            AND FIND_IN_SET(cb.id, i.booking_id) > 0
        ORDER BY cb.id DESC
");
// $packageBookings = "
//         SELECT pb.*, i.invoice_number 
//         FROM package_bookings pb 
//         LEFT JOIN invoices i 
//             ON FIND_IN_SET('package_bookings', i.booking_type) > 0 
//             AND FIND_IN_SET(pb.id, i.booking_id) > 0
//         ORDER BY pb.id DESC
//     ";
// $propertyBookings = "
//         SELECT pb.*, i.invoice_number 
//         FROM property_bookings pb 
//         LEFT JOIN invoices i 
//             ON FIND_IN_SET('property_bookings', i.booking_type) > 0 
//             AND FIND_IN_SET(pb.id, i.booking_id) > 0
//         ORDER BY pb.id DESC
//     ";
//     $carBookings = "
//         SELECT cb.*, i.invoice_number 
//         FROM car_bookings cb 
//         LEFT JOIN invoices i 
//             ON FIND_IN_SET('car_bookings', i.booking_type) > 0 
//             AND FIND_IN_SET(cb.id, i.booking_id) > 0
//         ORDER BY cb.id DESC
//     ";
// $propertyBookings = mysqli_query($conn, "
//     SELECT pb.*, i.invoice_number 
//     FROM property_bookings pb 
//     LEFT JOIN invoices i ON i.booking_type = 'property_bookings' AND i.booking_id = pb.id
//     ORDER BY pb.id DESC
// ");

// $carBookings = mysqli_query($conn, "
//     SELECT cb.*, i.invoice_number 
//     FROM car_bookings cb 
//     LEFT JOIN invoices i ON i.booking_type = 'car_bookings' AND i.booking_id = cb.id
//     ORDER BY cb.id DESC
// ");

?>
<style>
/* Make table scrollable on small screens */
@media only screen and (max-width: 767px) {
    .responsive-table-wrapper {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    table {
        width: 100%;
        min-width: 600px; /* Set based on number of columns */
        border-collapse: collapse;
    }

    table th, table td {
        white-space: nowrap;
    }
}

</style>
<main id="main-container">
<div class="container mt-5">
    <h2 class="text-center mb-4">All Bookings</h2>

    <ul class="nav nav-tabs" id="bookingTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="package-tab" data-bs-toggle="tab" data-bs-target="#package" type="button" role="tab">Tour Package Bookings</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="property-tab" data-bs-toggle="tab" data-bs-target="#property" type="button" role="tab">Property Bookings</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="car-tab" data-bs-toggle="tab" data-bs-target="#car" type="button" role="tab">Car Bookings</button>
        </li>
    </ul>

    <div class="tab-content mt-3" id="bookingTabsContent">
        <!-- Package Bookings -->
        <div class="tab-pane fade show active responsive-table-wrapper" id="package" role="tabpanel">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th><th>Invoice No</th><th>Customer</th>
                        <th>Total</th><<th>Date</th><th>Status</th><th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = mysqli_fetch_assoc($packageBookings)) {
                        if($row['payment_type']=='advance'){
                            $paid=$row['advance_amount'];
                        }else{
                            $paid=$row['total_amount'];
                        }
                    ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= $row['invoice_number'] ?? '-' ?></td>
                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-user me-1 text-primary"></i> <?= htmlspecialchars($row['full_name']) ?></span>
                                <span><i class="fas fa-envelope me-1 text-danger"></i> <?= htmlspecialchars($row['email']) ?></span>
                                <span><i class="fas fa-phone me-1 text-success"></i> <?= htmlspecialchars($row['phone']) ?></span>
                            </div>
                        </td>

                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-file-invoice-dollar text-dark me-1"></i> ₹<?= $row['total_amount'] ?></span>
                                <span>
                                    <i class="fas fa-money-bill-wave text-success me-1"></i> ₹<?= $paid ?>
                                    <button class="btn btn-sm btn-outline-primary btn-update-paid ms-2"
                                            data-id="<?= $row['id'] ?>"
                                            data-paid="<?= $paid ?>"
                                            data-booking-type="package"
                                            data-total="<?= $row['total_amount'] ?>"
                                            data-inv="<?= $row['invoice_number'] ?>"
                                            title="Update Paid Amount">
                                        <i class="fas fa-pen"></i>
                                    </button>
                                </span>

                                <span><i class="fas fa-wallet text-danger me-1"></i> ₹<?= $row['total_amount'] - $paid ?></span>
                            </div>
                        </td>

                        <td><?= $row['created_at'] ?></td>
                        <td>
                            <span id="status-<?= $row['id'] ?>" class="d-none"><?= $row['status'] ?></span>
                        
                            <div class="input-group input-group-sm" style="max-width: 250px;">
                                <select class="custom-select status-select" data-booking-id="<?= $row['id'] ?>" data-booking-type="package">
                                    <option value="pending" <?= $row['status'] == 'pending' ? 'selected' : '' ?>>
                                        ⏳ Pending
                                    </option>
                                    <option value="confirm" <?= $row['status'] == 'confirm' ? 'selected' : '' ?>>
                                        ✅ Confirmed
                                    </option>
                                    <option value="reject" <?= $row['status'] == 'reject' ? 'selected' : '' ?>>
                                        ❌ Rejected
                                    </option>
                                </select>
                                <div class="input-group-append">
                                    <button class="btn btn-success update-status" title="Update Status"
                                        data-booking-id="<?= $row['id'] ?>" data-booking-type="package">
                                        <i class="fas fa-check-circle"></i>
                                    </button>
                                </div>
                            </div>
                        </td>

                        <td>
                            <a href="../../invoice/index.php?id=<?= $row['invoice_number'] ?>" class="btn btn-sm btn-warning text-dark"><i class="fa fa-receipt"></i></a>
                            <button class="btn btn-sm btn-info view-message-btn" 
                                    data-id="<?= $row['id'] ?>" 
                                    data-message="<?= htmlspecialchars($row['message'], ENT_QUOTES) ?>" 
                                    title="View Message">
                                <i class="fa fa-envelope-open-text"></i>
                            </button>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>

        <!-- Property Bookings -->
        <div class="tab-pane fade responsive-table-wrapper" id="property" role="tabpanel">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th><th>Invoice No</th><th>Customer</th><th>Total</th><th>Date</th><th>Status</th><th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = mysqli_fetch_assoc($propertyBookings)) { 
                        if($row['payment_type']=='advance'){
                            $paid=$row['advance_amount'];
                        }else{
                            $paid=$row['total_amount'];
                        }
                        ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= $row['invoice_number'] ?? '-' ?></td>
                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-user me-1 text-primary"></i> <?= htmlspecialchars($row['name']) ?></span>
                                <span><i class="fas fa-envelope me-1 text-danger"></i> <?= htmlspecialchars($row['email']) ?></span>
                                <span><i class="fas fa-phone me-1 text-success"></i> <?= htmlspecialchars($row['phone']) ?></span>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-file-invoice-dollar text-dark me-1"></i> ₹<?= $row['total_amount'] ?></span>
                                <!-- Paid Section + Update Button -->
                                <span>
                                    <i class="fas fa-money-bill-wave text-success me-1"></i> ₹<?= $paid ?>
                                    <button class="btn btn-sm btn-outline-primary btn-update-paid ms-2"
                                            data-id="<?= $row['id'] ?>"
                                            data-paid="<?= $paid ?>"
                                            data-total="<?= $row['total_amount'] ?>"
                                            data-inv="<?= $row['invoice_number'] ?>"
                                            data-booking-type="property"
                                            title="Update Paid Amount">
                                        <i class="fas fa-pen"></i>
                                    </button>
                                </span>

                                <span><i class="fas fa-wallet text-danger me-1"></i> ₹<?= $row['total_amount'] - $paid ?></span>
                            </div>
                        </td>
                        <td><?= $row['created_at'] ?></td>
                        <td>
                            <span id="status-<?= $row['id'] ?>" class="d-none"><?= $row['status'] ?></span>
                        
                            <div class="input-group input-group-sm" style="max-width: 250px;">
                                <select class="custom-select status-select" data-booking-id="<?= $row['id'] ?>" data-booking-type="property">
                                    <option value="pending" <?= $row['status'] == 'pending' ? 'selected' : '' ?>>
                                        ⏳ Pending
                                    </option>
                                    <option value="confirm" <?= $row['status'] == 'confirm' ? 'selected' : '' ?>>
                                        ✅ Confirmed
                                    </option>
                                    <option value="reject" <?= $row['status'] == 'reject' ? 'selected' : '' ?>>
                                        ❌ Rejected
                                    </option>
                                </select>
                                <div class="input-group-append">
                                    <button class="btn btn-success update-status" title="Update Status"
                                        data-booking-id="<?= $row['id'] ?>" data-booking-type="property">
                                        <i class="fas fa-check-circle"></i>
                                    </button>
                                </div>
                            </div>
                        </td>
                        <td>
                            <a href="../../invoice/index.php?id=<?= $row['invoice_number'] ?>" class="btn btn-sm btn-warning text-dark"><i class="fa fa-receipt"></i></a>
                            <button class="btn btn-sm btn-info view-message-btn" 
                                    data-id="<?= $row['id'] ?>" 
                                    data-message="<?= htmlspecialchars($row['message'], ENT_QUOTES) ?>" 
                                    title="View Message">
                                <i class="fa fa-envelope-open-text"></i>
                            </button>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>

        <!-- Car Bookings -->
        <div class="tab-pane fade responsive-table-wrapper" id="car" role="tabpanel">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>#</th><th>Invoice No</th><th>Customer</th><th>Total</th><th>Date</th><th>Status</th><th>Invoice</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i=1; while($row = mysqli_fetch_assoc($carBookings)) {
                    if($row['payment_type']=='advance'){
                        $paid=$row['advance_amount'];
                    }else{
                        $paid=$row['total_amount'];
                    }
                    ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= $row['invoice_number'] ?? '-' ?></td>
                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-user me-1 text-primary"></i> <?= htmlspecialchars($row['full_name']) ?></span>
                                <span><i class="fas fa-envelope me-1 text-danger"></i> <?= htmlspecialchars($row['email']) ?></span>
                                <span><i class="fas fa-phone me-1 text-success"></i> <?= htmlspecialchars($row['phone']) ?></span>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex flex-column">
                                <span><i class="fas fa-file-invoice-dollar text-dark me-1"></i> ₹<?= $row['total_amount'] ?></span>
                                <!-- Paid Section + Update Button -->
                                <span>
                                    <i class="fas fa-money-bill-wave text-success me-1"></i> ₹<?= $paid ?>
                                    <button class="btn btn-sm btn-outline-primary btn-update-paid ms-2"
                                            data-id="<?= $row['id'] ?>"
                                            data-paid="<?= $paid ?>"
                                            data-total="<?= $row['total_amount'] ?>"
                                            data-inv="<?= $row['invoice_number'] ?>"
                                            data-booking-type="car"
                                            title="Update Paid Amount">
                                        <i class="fas fa-pen"></i>
                                    </button>
                                </span>

                                <span><i class="fas fa-wallet text-danger me-1"></i> ₹<?= $row['total_amount'] - $paid ?></span>
                            </div>
                        </td>
                        <td><?= $row['created_at'] ?></td>
                        <td>
                            <span id="status-<?= $row['id'] ?>" class="d-none"><?= $row['status'] ?></span>
                        
                            <div class="input-group input-group-sm" style="max-width: 250px;">
                                <select class="custom-select status-select" data-booking-id="<?= $row['id'] ?>" data-booking-type="car">
                                    <option value="pending" <?= $row['status'] == 'pending' ? 'selected' : '' ?>>
                                        ⏳ Pending
                                    </option>
                                    <option value="confirm" <?= $row['status'] == 'confirm' ? 'selected' : '' ?>>
                                        ✅ Confirmed
                                    </option>
                                    <option value="reject" <?= $row['status'] == 'reject' ? 'selected' : '' ?>>
                                        ❌ Rejected
                                    </option>
                                </select>
                                <div class="input-group-append">
                                    <button class="btn btn-success update-status" title="Update Status"
                                        data-booking-id="<?= $row['id'] ?>" data-booking-type="car">
                                        <i class="fas fa-check-circle"></i>
                                    </button>
                                </div>
                            </div>
                        </td>
                        <td>
                            <a href="../../invoice/index.php?id=<?= $row['invoice_number'] ?>" class="btn btn-sm btn-warning text-dark"><i class="fa fa-receipt"></i></a>
                            <button class="btn btn-sm btn-info view-message-btn" 
                                    data-id="<?= $row['id'] ?>" 
                                    data-message="<?= htmlspecialchars($row['message'], ENT_QUOTES) ?>" 
                                    title="View Message">
                                <i class="fa fa-envelope-open-text"></i>
                            </button>
                            
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</main>
<!-- Message Modal -->
<div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title" id="messageModalLabel"><i class="fa fa-envelope"></i> Booking Message</h5>
        <button type="button" class="btn-close text-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p id="bookingMessage" class="mb-0"></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
            <i class="fa fa-times"></i> Close
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Update Paid Amount Modal -->
<div class="modal fade" id="updatePaidModal" tabindex="-1" aria-labelledby="updatePaidModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="updatePaidForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Update Paid Amount</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <!-- Hidden Fields -->
          <input type="hidden" name="booking_id" id="paidBookingId">
          <input type="hidden" name="booking_type" id="paidBookingType">
          <input type="hidden" id="dueAmount">
          <input type="hidden" name="invoice_id" id="invoiceId"> 
          <!--<input type="hidden" name="invoice/_id" id="paidInvoiceId"> -->

          <div class="mb-2">
            <label class="form-label">Total Amount</label>
            <input type="text" class="form-control" id="totalAmount" disabled>
          </div>

          <div class="mb-2">
            <label class="form-label">Already Paid</label>
            <input type="text" class="form-control" id="alreadyPaidAmount" disabled>
          </div>

          <div class="mb-2">
            <label class="form-label">Due Amount</label>
            <input type="text" class="form-control text-danger fw-bold" id="dueDisplay" disabled>
          </div>

          <div class="mb-3">
            <label for="nowPaidAmount" class="form-label">Now Paying</label>
            <input type="number" class="form-control" name="now_paid_amount" id="nowPaidAmount" required min="1">
            <div class="invalid-feedback">Amount must be ≤ due.</div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Submit</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        </div>
      </div>
    </form>
  </div>
</div>

<?php
// Include footer file for Dashmix template
include('resources/footer.php');
?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll('.view-message-btn').forEach(button => {
        button.addEventListener('click', function () {
            const message = this.getAttribute('data-message');
            const messageContainer = document.getElementById('bookingMessage');
            messageContainer.innerHTML = message.replace(/\n/g, "<br>"); // Preserve line breaks
            const modal = new bootstrap.Modal(document.getElementById('messageModal'));
            modal.show();
        });
    });
});
</script>

<script>
$(document).ready(function() {
    // Listen for the "Update Status" button click
    $('.update-status').on('click', function() {
        var $row = $(this).closest('tr');
        var bookingId = $(this).data('booking-id'); // Get the booking ID
        var newStatus = $row.find('.status-select').val();
        // var newStatus = $('.status-select[data-booking-id="' + bookingId + '"]').val(); // Get the new status
        var bookingType = $(this).data('booking-type'); // Get the booking type (package, property, car)
        console.log("Booking ID:", bookingId);
        console.log("New Status:", newStatus);
        console.log("Booking Type:", bookingType);
        // Send AJAX request to update the status
        $.ajax({
            url: 'update_booking_status.php',  // PHP script to update status
            type: 'POST',
            data: {
                id: bookingId,
                status: newStatus,
                booking_type: bookingType
            },
            success: function(response) {
                // Update the status text in the table after success
                if (response.success) {
                    $('#status-' + bookingId).text(newStatus);
                    // alert('Status updated successfully!');
                } else {
                    // alert('Failed to update status!');
                }
            },
            error: function() {
                alert('Error updating status!');
            }
        });
    });
    
    $('.btn-update-paid').on('click', function () {
    const bookingId = $(this).data('id');
    const paid = parseFloat($(this).data('paid'));
    const total = parseFloat($(this).data('total'));
    const type = $(this).data('booking-type');
    const inv = $(this).data('inv');

    const due = total - paid;

    $('#paidBookingId').val(bookingId);
    $('#paidBookingType').val(type);
    $('#invoiceId').val(inv);
    $('#totalAmount').val(`₹${total}`);
    $('#alreadyPaidAmount').val(`₹${paid}`);
    $('#dueDisplay').val(`₹${due}`);
    $('#dueAmount').val(due);
    $('#nowPaidAmount').val('').removeClass('is-invalid');

    $('#updatePaidModal').modal('show');  
  });
$('#updatePaidForm').on('submit', function (e) {
  e.preventDefault();

  const nowPaid = parseFloat($('#nowPaidAmount').val());
  const due = parseFloat($('#dueAmount').val());
  const formData = $(this).serialize();

  console.log('--- DEBUG: Form Submission ---');
  console.log('Now Paying:', nowPaid);
  console.log('Due:', due);
  console.log('Serialized Data:', formData);
  console.log('Booking ID:', $('#paidBookingId').val());
  console.log('Booking Type:', $('#paidBookingType').val());
  console.log('Invoice ID:', $('#invoiceId').val());

  if (isNaN(nowPaid) || nowPaid <= 0 || nowPaid > due) {
    console.warn('Invalid payment amount');
    $('#nowPaidAmount').addClass('is-invalid');
    return;
  } else {
    $('#nowPaidAmount').removeClass('is-invalid');
  }

  // Submit form via AJAX
  $.ajax({
    url: 'update_paid_amount.php',
    type: 'POST',
    data: formData,
    success: function (res) {
      console.log('Server response:', res);
      $('#updatePaidModal').modal('hide');
      location.reload(); // Or update UI dynamically
    },
    error: function (xhr, status, error) {
      console.error('AJAX error:', error);
      console.error('Status:', status);
      console.error('Response:', xhr.responseText);
      alert('Error updating paid amount.');
    }
  });
});

});
</script>
