<?php
include('./resources/header.php');
?>
<main id="main-container">
    <div class="content">
        <div class="block block-rounded">
            <div class="block-header block-header-default">
                <h3 class="block-title">Add Package</h3>
            </div>
            <div class="block-content">
                <form class="mb-4 " action="insert_Action.php" method="POST" enctype="multipart/form-data" onsubmit="return validateValues()">
                    <h2 class="content-heading">Basic Information</h2>

                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="status">Status</label>
                                <select class="form-select" id="status" name="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                   
                                </select>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="package_title">Package Title</label>
                                <input type="text" class="form-control" id="package_title" name="package_title"
                                    placeholder="Enter Package Title..">
                                     <span id="package_error" class="error-message text-danger" style="font-size: 10px;"></span>
                                    
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="duration">Duration</label>
                                <input type="text" class="form-control" id="duration" name="duration"
                                    placeholder="Enter Duration(E.g.,3 nights/4 days)..">
                                     <span id="duration_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="starting_from">Starting From</label>
                                <input type="date" class="form-control" id="starting_from" name="starting_from"
                                    placeholder="Enter Starting Date..">
                                     <span id="starting_from_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="ending_at">Ending At</label>
                                <input type="date" class="form-control" id="ending_at" name="ending_at"
                                    placeholder="Enter Ending Date..">
                                     <span id="ending_at_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Overview and Description</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="sDescription">Short Description</label>
                                <textarea class="form-control" id="simplemde" name="short_description"
                                    placeholder="enter short description.."></textarea>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="fDescription">Full Description</label>

                                <textarea class="form-control" id="simplemde" name="full_description"
                                    placeholder="enter full description.."></textarea>

                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="street">Inclusions</label>
                                <input type="text" class="form-control" id="inclusions" name="inclusions"
                                    placeholder="Enter Inclusions..">
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="street">Exclusions</label>
                                <input type="text" class="form-control" id="exclusions" name="exclusions"
                                    placeholder="Enter Exclusions..">
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Pricing Details</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="street">Price per Person(Adult)</label>
                                <input type="number" class="form-control" id="person_price" name="person_price"
                                    placeholder="Enter price per Person(Adult)..">
                                     <span id="person_price_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="street">Price per Person(Child)</label>
                                <input type="number" class="form-control mb-2" id="child_price" name="child_price"
                                    placeholder="Enter price per Person(child)..">
                                    <span id="child_price_error" class="error-message text-danger" style="font-size: 10px;"></span>
                                <input type="radio" name="bed" value="With Bed">With Bed
                                <input type="radio" name="bed" value="Without Bed">Without Bed
                            </div>
                           <div class="mb-4 col-lg-6 col-sm-12">
                             <label class="form-label d-block">Group Discount Available?</label>

                                    <div class="form-check form-check-inline">
                                       <input class="form-check-input" type="radio" name="group_discount" id="group_discount_yes" value="yes">
                                       <label class="form-check-label" for="group_discount_yes">Yes</label>
                                   </div>

                                  <div class="form-check form-check-inline">
                                      <input class="form-check-input" type="radio" name="group_discount" id="group_discount_no" value="no">
                                      <label class="form-check-label" for="group_discount_no">No</label>
                                 </div>

    <span id="group_discount_error" class="error-message text-danger" style="font-size: 10px;"></span>
</div>
                           <div class="mb-4 col-lg-6 col-sm-12">
                                 <label class="form-label d-block">Custom Quote Option?</label>

                                 <div class="form-check form-check-inline">
                                 <input class="form-check-input" type="radio" name="custom_quote" id="custom_quote_yes" value="yes">
                                <label class="form-check-label" for="custom_quote_yes">Yes</label>
                                 </div>

                                <div class="form-check form-check-inline">
                                 <input class="form-check-input" type="radio" name="custom_quote" id="custom_quote_no" value="no">
                                  <label class="form-check-label" for="custom_quote_no">No</label>
                                </div>

                           <span id="custom_quote_error" class="error-message text-danger" style="font-size: 10px;"></span>
                           </div>
                            <div class="mb-4 col-lg-8 col-sm-12">
                                <label class="form-label" for="payment">Payment Terms</label>
                                <input type="text" class="form-control" id="payment" name="payment"
                                    placeholder="Enter Payment Terms..">
                                    <span id="payment_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-8 col-sm-12">
                                <label class="form-label" for="cancellation">Cancellation</label>
                                <input type="text" class="form-control" id="cancellation" name="cancellation"
                                    placeholder="Enter Cancellation Policy..">
                            </div>
                        </div>
                    </div>
                    <h2 class="content-heading">Tags/SEO Fields</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="tags">Tags/Keywords </label>
                                <input type="text" class="form-control" id="tags" name="tags"
                                    placeholder="Enter Tags/Keywords..">
                                    <span id="tags_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="meta_title">Meta Title</label>
                                <input type="text" class="form-control" id="meta_title" name="meta_title"
                                    placeholder="Enter Meta Title..">
                                    <span id="meta_title_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="meta_description">Meta Description</label>
                                <textarea class="form-control" id="simplemde" name="meta_description"
                                    placeholder="enter meta description.."></textarea>
                            </div>
                            <div class="mb-4 col-lg-6 col-sm-12">
                                <label class="form-label" for="slug">Slug/URL</label>
                                <input type="text" class="form-control" id="url" name="url"
                                    placeholder="Enter URL..">
                                    <span id="url_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                            
                            <div class="mb-4 col-lg-6 col-sm-12">
                                  <label class="form-label" for="feature">Feature</label>
                                  <select class="form-control" id="feature" name="feature">
                                        <option value="">-- Select --</option>
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                  </select>
                                <span id="feature_error" class="error-message text-danger" style="font-size: 10px;"></span>
                           </div>
                            
                        </div>
                    </div>
                    <h2 class="content-heading">Package Image</h2>
                    <div class="row push mx-4">
                        <div class="row col-12 overflow-hidden">
                            <div class="mb-4 col-lg-12 col-sm-12">
                                <label class="form-label" for="package_image">Upload Image</label>
                                <input class="form-control" type="file" id="package_image" name="package_image">
                                <span id="package_image_error" class="error-message text-danger" style="font-size: 10px;"></span>
                            </div>
                        </div>
                    </div>
                    <center>
                        <div class="mb-4 col-lg-4 col-sm-12 p-5 mx-4">
                            <button type="submit" name="package_submit" value="package_submit"
                                class="btn btn-primary w-100">Save</button>
                        </div>
                    </center>
                </form>
            </div>
        </div>
    </div>
</main>

<?php
include('./resources/footer.php');
?>
<script>
function validateValues() {
    // Reset all error messages
    var errorMessages = document.querySelectorAll('.error-message');
    errorMessages.forEach(function(msg) {
        msg.textContent = '';
    });

    // Validate car image size
    var package_image = document.getElementById('package_image');
    var package_image_error = document.getElementById('package_image_error');
    if (package_image.files.length > 0) {
        var fileSize = package_image.files[0].size / 1024 / 1024; // Convert size to MB
        if (fileSize > 2) {
            package_image_error.textContent = '*Image size must be less than or equal to 2MB.';
            return false;
        } else {
            package_image_error.textContent = '';
        }
    } else {
        package_image_error.textContent = '*Please upload a package image.';
        return false;
    }

    // Validate package title
    var package_title = document.getElementById('package_title').value.trim();
    var package_error = document.getElementById('package_error');
    if (package_title === '') {
        package_error.textContent = '*Package Title is required.';
        return false;
    } else {
        package_error.textContent = '';
    }

    // Validate duration
    var duration = document.getElementById('duration').value;
    var duration_error = document.getElementById('duration_error');
    if (duration === '') {
        duration_error.textContent = '*Please enter duration.';
        return false;
    } else {
        duration_error.textContent = '';
    }
    // Validate starting date
    var starting_from = document.getElementById('starting_from').value;
    var starting_from_error = document.getElementById('starting_from_error');
    if (starting_from === '') {
        starting_from_error.textContent = '*Please enter starting date.';
        return false;
    } else {
        starting_from_error.textContent = '';
    }
    // Validate ending at
    var ending_at = document.getElementById('ending_at').value;
    var ending_at_error = document.getElementById('ending_at_error');
    if (ending_at === '') {
        ending_at_error.textContent = '*Please enter ending date.';
        return false;
    } else {
        ending_at_error.textContent = '';
    }
    // Validate person price
    var person_price = document.getElementById('person_price').value.trim();
    var person_price_error = document.getElementById('person_price_error');
    if (person_price === '') {
        person_price_error.textContent = '*Person price is required.';
        return false;
    } else {
        person_price_error.textContent = '';
    }

    // Validate child price
    var child_price = document.getElementById('child_price').value;
    var child_price_error = document.getElementById('child_price_error');
    if (child_price === '') {
        child_price_error.textContent = '*Child price is required..';
        return false;
    } else {
        child_price_error.textContent = '';
    }

    // Validate Spot A selection
    var group_discount = document.getElementById('group_discount').value;
    var group_discount_error = document.getElementById('group_discount_error');
    if (group_discount === '') {
        group_discount_error.textContent = '*Please select  group discount.';
        return false;
    } else {
        group_discount_error.textContent = '';
    }

    // Validate Spot B selection
    var custom_quote = document.getElementById('custom_quote').value;
    var custom_quote_error = document.getElementById('custom_quote_error');
    if (custom_quote === '') {
        custom_quote_error.textContent = '*Please select custom quote.';
        return false;
    } else {
        custom_quote_error.textContent = '';
    }
// Validate Spot B selection
var payment = document.getElementById('payment').value;
var payment_error = document.getElementById('payment_error');
if (payment === '') {
    payment_error.textContent = '*Please enter payment terms.';
    return false;
} else {
    payment_error.textContent = '';
}
// Validate Spot B selection
var tags = document.getElementById('tags').value;
var tags_error = document.getElementById('tags_error');
if (tags === '') {
    tags_error.textContent = '*Please enter tags.';
    return false;
} else {
    tags_error.textContent = '';
}
// Validate Spot B selection
var meta_title = document.getElementById('meta_title').value;
var meta_title_error = document.getElementById('meta_title_error');
if (meta_title === '') {
    meta_title_error.textContent = '*Please enter meta title..';
    return false;
} else {
    meta_title_error.textContent = '';
}
// Validate Spot B selection
var url = document.getElementById('url').value;
var url_error= document.getElementById('url_error');
if (url === '') {
    url_error.textContent = '*Please enter url.';
    return false;
} else {
    url_error.textContent = '';
}
// Validate Spot B selection
var feature = document.getElementById('feature').value;
var feature_error= document.getElementById('feature_error');
if (feature === '') {
    feature_error.textContent = '*Please enter feature.';
    return false;
} else {
    feature_error.textContent = '';
}


    // If all validations pass, submit the form
    return true;
}
</script>